﻿var topic4 = {  
	topicInfo:{ 	
			topicId : 1,
			topicName : "6200 Series LC/TOF and 6500 Series <br>LC/Q-TOF",
			iconPath : "images/submenuicon/6500_Series_QTOF_LCMS.png",
			small_iconPath : "images/sprite/no_image.png",
			chapterList:{
				1:{ 			
					chapterName : "Important",
					iconPath : "images/submenuicon/important_icon.png",
					subChapterList:{
						1:{
							subChapterName : "Important",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [	
										{  
										title: "Warranty" ,
										short_title: "Warranty" ,
										type: "text_image" ,
										content:'<div id="dataContainer"><div class="textContainer textContainer_100">The material contained in this document is provided “as is,” and is subject to being changed, without notice, in future editions. Further, to the maximum extent permitted by applicable law, Agilent disclaims all warranties, either express or implied, with regard to this manual and any information contained herein, including but not limited to the implied warranties of merchantability and fitness for a particular purpose.<p> Agilent shall not be liable for errors or for incidental or consequential damages in connection with the furnishing, use, or performance of this document or of any information contained herein. Should Agilent and the user have a separate written agreement with warranty terms covering the material in this document that conflict with these terms, the warranty terms in the separate agreement shall control.</p></div></div>',
										details: {									
												1:{
													text: "Warranty , The material contained in this document is provided “as is,” and is subject to being changed, without notice, in future editions. Further, to the maximum extent permitted by applicable law, Agilent disclaims all warranties, either express or implied, with regard to this manual and any information contained herein, including but not limited to the implied warranties of merchantability and fitness for a particular purpose. , Agilent shall not be liable for errors or for incidental or consequential damages in connection with the furnishing, use, or performance of this document or of any information contained herein. Should Agilent and the user have a separate written agreement with warranty terms covering the material in this document that conflict with these terms, the warranty terms in the separate agreement shall control."
												  },								 
												}
										},
										
										{  
										title: "Safety notices" ,
										short_title: "Safety notices" ,
										type: "text_image" ,
										content:'<div id="dataContainer"><div class="textContainer textContainer_100"><span class="caution">CAUTION</span> <br><br>A CAUTION notice denotes a hazard. It calls attention to an operating procedure, practice, or the like that, if not correctly performed or adhered to, could result in damage to the product or loss of important data. Do not proceed beyond a CAUTION notice until the indicated conditions are fully understood and met.<br><br><span class="warning">WARNING</span><br><br>A WARNING notice denotes a hazard. It calls attention to an operating procedure, practice, or the like that, if not correctly performed or adhered to, could result in personal injury or death. Do not proceed beyond a WARNING notice until the indicated conditions are fully understood and met.</div></div>',
										details: {									
												1:{
													text: "Safety notices , A CAUTION notice denotes a hazard. It calls attention to an operating procedure, practice, or the like that, if not correctly performed or adhered to, could result in damage to the product or loss of important data. Do not proceed beyond a CAUTION notice until the indicated conditions are fully understood and met. , A WARNING notice denotes a hazard. It calls attention to an operating procedure, practice, or the like that, if not correctly performed or adhered to, could result in personal injury or death. Do not proceed beyond a WARNING notice until the indicated conditions are fully understood and met."
												  },								 
												}
										},
										{  
												title: "Overview" ,
												short_title: "Overview" ,
												type: "text_image" ,
												content : '<div id="dataContainer"><div class="textContainer textContainer_100">This section describes how to properly prepare your site for a new Agilent LC/MS instrument. Follow these instructions carefully as delays due to improper site preparation may result in loss of instrument use during the warranty period.<p>Before the Agilent LC/TOF or LC/Q-TOF system can be installed, the site must be properly prepared. Site preparation includes, but is not limited to, ensuring that adequate facilities are available. Among the site requirements are:<div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/power_51.jpg"></img></div><p style="float:left;">Adequate electrical power is available at the correct voltages and frequencies.</p><div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/Envorment.jpg"></img></div><p style="float:left;">Environmental control systems are adequate to maintain a correct, stable operating environment.</p><div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/Dry_nitrogen_gas.jpg"></img></div><p style="float:left;">An adequate source of clean, dry nitrogen gas. <br> An adequate source of ultrapure nitrogen for collision cell gas. For IM-QTOF, an adequate source of ultrapure nitrogen for the drift tube.</p><div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/venting.jpg"></img></div><p style="float:left;">Adequate exhaust venting.</p><div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/Paper.jpg"></img></div><p style="float:left;margin:15px 10px 0px 0px;">Supplies necessary for instrument operation are available, including solvents, carrier and reagent gases, and printer paper.</p></div><div class="textContainer textContainer_100"> <p>Refer to the Site Preparation Checklist for specific requirements.​</p></div></div>' ,
												details: {										
													1:{
														text: "Overview , This section describes how to properly prepare your site for a new Agilent 6500 Series Q-TOF LC/MS. Follow these instructions carefully as delays due to improper site preparation may result in loss of instrument use during the warranty period. , Before the Agilent LC/TOF or LC/Q-TOF system can be installed, the site must be properly prepared. Site preparation includes, but is not limited to, ensuring that adequate facilities are available. Among the site requirements are: , Adequate electrical power is available at the correct voltages and frequencies. , Environmental control systems are adequate to maintain a correct, stable operating environment. ,An adequate source of clean, dry nitrogen gas. An adequate source of ultrapure nitrogen for collision cell gas. For IM-QTOF, an adequate source of ultrapure nitrogen for the drift tube., Adequate exhaust venting. , Supplies necessary for instrument operation are available, including solvents, carrier and reagent gases, and printer paper.,Refer to the Site Preparation Checklist for specific requirements.​" 
													},								 
												}
											},
											{  
												title: "Overview" ,
												short_title: "blank",
												type: "text_image" ,
												content : '<div id="dataContainer"><div class="textContainer textContainer_100">Delays due to inadequate site preparation could cause loss of instrument use during the warranty period. In extreme cases, Agilent Technologies may ask to be reimbursed for the additional time required to complete the installation. <p><i>Agilent Technologies provides service during the warranty period and under maintenance agreements only if the specified site requirements are met.</i></p></div></div>' ,
												details: {										
													1:{
														text: "Overview , Delays due to inadequate site preparation could cause loss of instrument use during the warranty period. In extreme cases, Agilent Technologies may ask to be reimbursed for the additional time required to complete the installation. , Agilent Technologies provides service during the warranty period and under maintenance agreements only if the specified site requirements are met." 
														},								 
													
												}
											},
										
									  ]	
						},// subchapter	  
						
					} // subchapter List 			
				}, // chapter 
				2:{ 			
					chapterName : "General information",
					iconPath : "images/submenuicon/General_Information.png",
					subChapterList:{
						1:{
							subChapterName : "General information",
							iconPath : "images/submenuicon/no_image.png",
							submenu : false,
							pageList : [	
										{  
										title: "Instrument identification" ,
										short_title: "Instrument identification" ,
										type: "text_image" ,
										content:'<div id="dataContainer"><div class="textContainer textContainer_100">Each Agilent LC/MS is identified by a unique 10-character serial number. This serial number is located on a label on the lower right front corner of the instrument. When corresponding with Agilent Technologies about your instrument, be sure to include the model number and the full 10-character serial number.</div><div class="imageContainer imageContainer_100"><img src="images/topic03/6500.png"></img></div></div>',
										details: {									
												1:{
													text: "Each Agilent LC/MS is identified by a unique 10-character serial number. This serial number is located on a label on the lower right front corner of the instrument. When corresponding with Agilent Technologies about your instrument, be sure to include the model number and the full 10-character serial number."
												  },								 
												}
										},

									  ]	
							} // subchapter	  
						} // subchapter List 			
				}, // chapter 
			 
				3:{ 			
					chapterName : "Lab space requirements",
					iconPath : "images/submenuicon/Q-TOF/Lab_Space_Requirements.png",
					subChapterList : {				
								1:{
									subChapterName : "Lab space requirements",
									iconPath : "images/submenuicon/Q-TOF/Lab_Space_Requirements.png",
									submenu : true,
									pageList : [
												{  
													title: "Bench requirement" ,
													short_title: "Bench requirement" ,
													type: "text_image" ,
													content : '<div id="dataContainer"><div class="textContainer textContainer_100">Supporting benches for the LC/MS are available from Agilent. Contact your Agilent representatives for ordering information on the appropriate bench for your lab.<br><br><span class="note">NOTE</span>The G3215A Mass Spec Bench with Ion Mobility extension is included with the 6560 Ion Mobility Q-TOF.<div class="imageContainer imageContainer_80" style="padding-top: 20px; float:none"><img src="images/topic03/bench_requirement.png"></img></div></div></div>' ,
													details:{									
														1:{
															text: "Bench requirement , Supporting benches for the 6500 Series Q-TOF LC/MS are available from Agilent. Contact your Agilent representatives for ordering information on the appropriate bench for your lab.,Note that the G3215A Mass Spec Bench with Ion Mobility extension is included with the 6560 Ion Mobility Q-TOF."
														},								 
													}
												}, // page
												{  
													title: "Bench requirement" ,
													short_title: "blank" ,
													type: "text_image" ,
													content : "<div id='dataContainer'><div class='textContainer textContainer_100'><ul><li>You cannot stack the LC instrument on top of the LC/MS instrument. This configuration is unstable and dangerous.</li><li>The height of the table must allow for the height of the instrument and a 10-cm (4-inch) clearance to allow the flight tube to hinge forward.</li><li>Removal or modification of ceiling tiles to accommodate the flight tube violates fire safety codes in certain geographies.</li><li>For the 6560 Ion Mobility Q-TOF, the bench or table where the instrument will be installed must be able to maintain a flat plane even when the load from the instrument is applied. The 6560 includes the G3215A Mass Spec Bench with IM-QTOF table extension. The table extension allows for precise leveling, even when the floor has small defects.</li></ul></div></div>" ,
													details:{									
														1:{
															text: "Bench requirement , You cannot stack the LC instrument on top of the LC/MS instrument. This configuration is unstable and dangerous. ,The height of the table must allow for the height of the instrument and a 10-cm (4-inch) clearance to allow the flight tube to hinge forward.,Removal or modification of ceiling tiles to accommodate the flight tube violates fire safety codes in certain geographies. , For the 6560 Ion Mobility Q-TOF, the bench or table where the instrument will be installed must be able to maintain a flat plane even when the load from the instrument is applied. The 6560 includes the G3215A Mass Spec Bench with IM-QTOF table extension. The table extension allows for precise leveling, even when the floor has small defects."
														},								 
													}
												}, // page
											
												{  
													title: "Bench requirement" ,
													short_title: "blank" ,
													type: "video" ,
													path : "video/topic04/Bench_Requirement.mp4" ,
													PdfPath : "pdf/topic03/Bench_Requirement.pdf",
													details: {														
														1:{ cuePoint : 1,
															tag:"Bench top requirements",
															text: "The bench on which the LCMS will sit must meet these requirements:<br>Large enough to fit the LC instrument, the LC/MS instrument, computer, and accessories.",
														},
													
														2:{ cuePoint : 5,
														tag:"blank",
														text: "The bench on which the LCMS will sit must meet these requirements:<br>Large enough to fit the LC instrument, the LC/MS instrument, computer, and accessories.<br>Enough space for ventilation and maintenance access. Sturdy enough to support the weight of the entire system. Enough space for ventilation and maintenance access. Sturdy enough to support the weight of the entire system.",
														},
													
														3:{ cuePoint : 22,
															tag:"Distance and Height Requirement",
															text: "For instruments with a 1.5 meter flight tube, the distance between the tabletop and the ceiling must exceed 203 cm (80 inches), which allows for the height of the instrument plus a 10 cm (4 inches) clearance to allow the flight tube to hinge forward. "
														},
													
														4:{ cuePoint :27,
															tag:"blank",
															text: "As an example, if your lab ceiling height is 9 foot (2.74 m or 108 inches), the instrument height is <br> 193 cm (76 inches), and the required clearance is 10 cm (4 inches), height of the bench cannot exceed 71 cm (28 inches)."
														},

														5:{ cuePoint :32,
															tag:"blank",
															text: ""
														},
														 	
													}
												},
								 
												{  
												title: "Space and weight requirements" ,
												short_title: "Space and weight requirements" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'><span class='caution'>CAUTION</span>Do not put the rough pump on your laboratory bench with the LC/MS due to the vibration that the pump creates. This vibration can lead to a loss of mass accuracy and resolution.<br><br>The bench space must be large enough and strong enough to support the LC/MS and LC system, data system, and accessories. The surface must be relatively free of vibration.​<br><br>Please refer to the Site Preparation Checklist, under <b>Dimensions and Weight</b>, for the LC/MS, source, and foreline pump dimensions and weight.​<br><br>You must leave at least 30 cm (12 inches) to the left of the source and the fan to provide adequate access and ventilation.</p> " ,
												details:{									
												1:{
												text: "Space and weight requirements , CAUTION , Do not put the rough pump on your laboratory bench with the LC/MS due to the vibration that the pump creates. This vibration can lead to a loss of mass accuracy and resolution.  ,  The bench space must be large enough and strong enough to support the LC/MS and LC system, data system, and accessories. The surface must be relatively free of vibration.​, Please refer to the Site Preparation Checklist, under Dimensions and Weight, for the LC/MS, source, and foreline pump dimensions and weight.​, You must leave at least 30 cm (12 inches) to the left of the source and the fan to provide adequate access and ventilation. "
												},								 
												}
												}, // page
												
												{  
												title: "Space and weight requirements" ,
												short_title: "blank",
												type: "video" ,
												path : "video/topic04/space_and_weight.mp4" ,
												PdfPath : "pdf/topic03/space_and_weight.pdf",
											
												details: {
												1:{ cuePoint : 0,
													tag:"Adequate space",
													text: "The installation site must have enough bench space for the LC/MS system, LC system, data system and accessories. In addition, there must be sufficient space around the instrumentation for air flow and maintenance access. "
												  },
											
												2:{ cuePoint :15,
													tag:"blank",
													text: " "
												  },
												  
												3:{ cuePoint :16,
													tag:"Suitable supporting bench",
													text: "At least 15 cm (approximately 6 inches) behind the LC/MS must kept clear."
												  },
												  
												4:{ cuePoint :22,
													tag:"blank",
													text: " "
												  },
											  
												5:{ cuePoint : 24,
													tag:"Dimensions of Q-TOF LC/MS",
													text: "Add 30 cm (12 inches) of space to the left of the source, and 8 cm (3 inches) to the right of the LC/MS, to provide adequate instrument access. "
												  },
												  
												6:{ cuePoint : 30,
													tag:"blank",
													text: " "
												  },
											
												7:{ cuePoint : 31,
													tag:"blank",
													text: "<span class='caution'>CAUTION</span>To mount the flight tube and for servicing: For instruments with a 1.5 meter flight tube, you must have at least a 160 cm (63 inches) clearance in front of the flight tube area. The flight tube is on a hinge and pivots towards the front of the instrument.​"
												  },
												  
												8:{ cuePoint : 36,
													tag:"blank",
													text: "<span class='caution'>CAUTION</span>For instruments with a 1 meter flight tube, you must leave at least 110 cm (43 inches) of free space in front of the flight tube area to mount the flight tube.  The flight tube is on a hinge and pivots towards the front of the instrument. This space is only needed during install or service."
												  },
	  
												9:{ cuePoint : 41,
													tag:"blank",
													text: "<span class='warning'>WARNING</span>Do not stack the LC modules on top of the LC/MS system. This arrangement is potentially unstable and dangerous."
												  },
												  
												10:{ cuePoint : 47,
													tag:"blank",
													text: " "
												  },
												  
												11:{ cuePoint : 48,
													tag:"blank",
													text: "The rough pump(s) must be located under the laboratory bench or on the floor. It must be within the 200 cm (79 inches) length of the vacuum hose."
												  },
												  
												12:{ cuePoint : 54,
													tag:"blank",
													text: "The LC/MS spray chamber must be connected to the spray chamber waste bottle which must be positioned below the LC/MS instrument. The drain bottle is supplied with a 180 cm (72 inches) PTFE hose."
												  },
	  
												13:{ cuePoint : 60,
													tag:"blank",
													text: "<span class='caution'>CAUTION</span>Do not put the rough pump on your laboratory bench with the LC/MS due to the vibration that the pump creates. This vibration can lead to a loss of mass accuracy and resolution. The supporting surface for the LC/MS system should be kept relatively vibration free."
												  },  
												
												}
												}, // page
												
												{  
												title: "Space and weight requirements configuration" ,
												short_title: "blank" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'><div class='imageContainer imageContainer_100'><img src='images/topic03/configuration.jpg'></img></div></div></div>" ,
												details:{									
												1:{
												text: "Space and weight requirements configuration"
												},								 
												}
												}, // page
												
												
												{  
												title: "Operating environment" ,
												short_title: "Operating environment" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'><h4>Environmental Conditions</h4>The LC/MS is designed for use in the following environmental conditions for Class 1 Laboratory Equipment.<table  style='margin-top:10px'><tr><td>Equipment class: Class</td><td>Class 1 Laboratory Equipment</td></tr><tr><td>Pollution</td><td>Degree 2</td></tr><tr><td>Installation</td><td>Category II</td></tr><tr><td>Environment</td><td>Indoor Use</td></tr><tr><td>Altitude</td><td>For 6545XT and 6546 only, not to exceed 2,000 m​. <br>For LC/TOF and all other LC/Q-TOF, not to exceed 3,000 m.</td></tr><tr><td>Electrical supply</td><td>See the Site Preparation Checklist for specific information for your model.</td></tr><tr><td rowspan='2' style='padding-bottom:45px'>Mains supply voltage</td><td>For ESI: Fluctuations not to exceed 10% of nominal supply voltage.</td></tr><tr><td>For AJS: Fluctuations not to exceed +10/-5% from the rated voltage.</td></tr><td>Operating temperature</td><td>15 to 35 °C (59 to 95 °F)</td></tr><tr><td>Humidity</td><td>< 85% RH at 35 °C</td></tr></table>" ,
												details:{									
												1:{
												text: "Operating environment , Environmental Conditions , The LC/MS is designed for use in the following environmental conditions for Class 1 Laboratory Equipment. , Equipment class: Class , Class 1 Laboratory Equipment , Pollution , Degree 2 , Installation , Category II , Environment , Indoor Use , Altitude , For 6545XT and 6546 only, not to exceed 2,000 m​, For LC/TOF and all other LC/Q-TOF, not to exceed 3,000 m, Electrical supply,	See the Site Preparation Checklist for specific information for your model., Mains supply voltage,For ESI: Fluctuations not to exceed 10% of nominal supply voltage.,For AJS: Fluctuations not to exceed +10/-5% from the rated voltage., Operating temperature	15 to 35 °C (59 to 95 °F), Humidity	< 85% RH at 35 °C, "
												},								 
												}
												}, // page
												
												{  
												title: "Operating environment" ,
												short_title: "blank" ,
												type: "video" ,
												path : "video/topic04/Operating_Environment.mp4" ,
												PdfPath : "pdf/topic03/Operating_Environment.pdf",
												details: 
														{
															
														1:{ cuePoint : 2,
														tag:"Altitude",
														text: "Altitude: Not to exceed 2,000 m for 6545XT/6546. Not to exceed 3,000 m for TOF and all other Q-TOF models.",
														},
														
														2:{ cuePoint : 5,
														tag:"Electrical supply",
														text: "Electrical supply: Refer to the Site Preparation Checklist for exact specifications.<br>Mains supply voltage fluctuation: ​<br>For ESI, not to exceed 10% of nominal supply voltage.​ <br>For AJS, not to exceed +10/-5% from the rated voltage."
														},
														
														3:{ cuePoint :11,
														tag:"Operating temperature",
														text: "Operating Temperature: 15 to 35&#176;C (59 to 95&#176;F) at constant temperature +/- 3°C from calibration temperature."
														},
														
														4:{ cuePoint :16,
														tag:"Humidity",
														text: "Humidity: 20-85% RH at 35&#176;C."
														},
														
														5:{ cuePoint :22,
														tag:"blank",
														text: " "
														},
														
													}
												},
												
												{  
												title: "Telephone" ,
												short_title: "Telephone" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div style='float:left;margin-right:10px;'><img src='images/topic01/Telephone.jpg'></div><div class='textContainer textContainer_80'>Agilent recommends that a telephone or cell phone service is available within reach of the computer. The Agilent Technologies field personnel may need to communicate with an Agilent support personnel.</div></div>" ,
												details:{									
												1:{
												text: "Telephone , Agilent recommends that a telephone or cell phone service is available within reach of the computer. The Agilent Technologies field personnel may need to communicate with an Agilent support personnel."
												},								 
												}
												}, // page
												
												{  
													title: "LAN network" ,
													short_title: "LAN network" ,
													type: "text_image" ,
													content : "<div class='imageContainer imageContainer_100' style='float:left'><img src='images/topic03/LAN.jpg'></img></div>" ,
													details:{									
													1:{
													text: "LAN network"
													},								 
													}
												}, // page
												
												{  
												title: "Site LAN network" ,
												short_title: "blank" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'> If you intend to connect the control PC to your site's LAN network, you need an additional network cable. Internet access for the control PC is strongly recommended to allow remote control and diagnosis of the LC/MS through remote access software. </br>This is required for some service contracts.​<br><br><span class='note'>NOTE</span>Agilent Technologies is not responsible for connecting to or establishing communication with your site LAN network. The service representative will test the ability of the Agilent instruments to communicate with the control PC only.<br><br><span class='note'>NOTE</span>The LC/MS has a fixed IP address. It can only connect to a control PC and not to the site network.​</div></div>" ,
												details:{									
												1:{
												text: "If you intend to connect your Agilent 6500 Series Q-TOF LC/MS system to your site's LAN network, you must have an additional shielded twisted pair network cable. In addition, internet access for the acquisition PC is strongly recommended to allow remote control and diagnosis of the Agilent 6500 Series Q-TOF LC/MS through desktop software. This is required for some service contracts.,NOTE ,Agilent Technologies is not responsible for connecting to or establishing communication with your site LAN network. The service representative will test the Agilent 6500 Series Q-TOF's ability to communicate with Agilent-supported PCs and data servers ONLY., NOTE, The IP address for the Agilent 6500 Series Q-TOF LC/MS is fixed and cannot be changed. Connecting the 6500 Series Q-TOF anywhere outside of the closed instrument network is not supported.​"
												},								 
												}
												}, // page
								
											]  //pageList
									}, // subChapter 
							}// subChapterList		
			}, // chapter		
			
			4:{ 			
					chapterName : "Air conditioning requirements",
					iconPath : "images/submenuicon/Q-TOF/Air_Conditioning_Requirements.png",
					subChapterList : {				
								1:{
									subChapterName : "Air conditioning requirements",
									iconPath : "images/submenuicon/Q-TOF/Air_Conditioning_Requirements.png",
									submenu : true,
									pageList : [
												{  
												title: "Temperature and humidity" ,
												short_title: "Temperature and humidity" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'>The Agilent 6200 Series LC/TOF and 6500 Series LC/Q-TOF are specified for operation under the following conditions:<ul><li>15 to 35°C (59 to 95°F)</li><li>Constant temperature (variations < 3°C/hr)</li><li>20-85% relative humidity at 35°C</li><li>Non-condensing, non-corrosive atmosphere</li></ul><p>Environmental control systems must maintain these temperatures and humidity ranges.</p> <p>The LC/MS, source, and rough pump dissipate a large amount of heat. For your system specifications, refer to the Site Preparation Checklist.​<br>The LC and data system also contribute significantly to the cooling load. The exact amounts depend on their configurations.</p><p>Additional allowances should be made for other heat sources such as heat from other equipment, heat from adjacent rooms, and heat from laboratory personnel.</p></div></div>" ,
												details:{									
												1:{
												text: "Temperature and humidity , The Agilent 6200 Series LC/TOF and 6500 Series LC/Q-TOF are specified for operation under the following conditions: , 15 to 35°C (59 to 95°F) , Constant temperature (variations < 3°C/hr) , 20-85% relative humidity at 35°C , Non-condensing, non-corrosive atmosphere , Environmental control systems must maintain these temperatures and humidity ranges. , The LC/MS, source, and rough pump dissipate a large amount of heat. For your system specifications, refer to the Site Preparation Checklist.​,The LC and data system also contribute significantly to the cooling load. The exact amounts depend on their configurations., Additional allowances should be made for other heat sources such as heat from other equipment, heat from adjacent rooms, and heat from laboratory personnel."
												},								 
												}
												}, // page
												
												{  
												title: "Temperature and humidity" ,
												short_title: "blank" ,
												type: "video" ,
												path : "video/topic04/temperature_n_humidity.mp4" ,
												PdfPath : "pdf/topic03/temperature_n_humidity.pdf",
											
												details: {
												1:{ cuePoint : 0,
													tag:"The LC/MS dissipates heat from the chassis and source",
													text: "The LC/MS dissipates heat from the chassis and source. Check the Site Preparation Checklist for rate of dissipation. "
												  },
												  2:{ cuePoint : 9,
													tag:"The foreline pump dissipates heat",
													text: "The foreline pump dissipates heat."
												  },
												  
												3:{ cuePoint : 10,
													tag:"The LC and data system also contribute significantly",
													text: "The LC and data system also contribute significantly. The exact amounts depend on their configurations."
												  },
												}
												}, // page
									 
												{  
												title: "Airborne dust" ,
												short_title: "Airborne dust" ,
												type: "video" ,
												path : "video/topic04/Airborne_Dust.mp4" ,
												PdfPath : "pdf/topic03/Airborne_Dust.pdf",
											
												details: {
												1:{ cuePoint : 0,
													tag:"Lab with airborne dust",
													text: "Agilent recommends a maximum airborne particle density of 55 mg/m<sup>3</sup>. If you suspect your site exceeds this limit, contact your local Agilent Customer Service Organization. They can offer suggestions for reducing airborne dust."
												  },
											
												2:{ cuePoint : 9,
													tag:"blank",
													text: " "
												  },
												  
												  
												}
												}, // page
												
												{  
												title: "Exhaust venting" ,
												short_title: "Exhaust venting" ,
												type: "video" ,
												path : "video/topic04/Exhaust_Venting.mp4" ,
												PdfPath : "pdf/topic03/Exhaust_Venting.pdf",
											
												details: {
												1:{ cuePoint : 0,
													tag:"Exhaust sources of the LC/MS",
													text: "Two sources of exhaust on the LC/MS: the spray chamber and the rough pump. "
												  },
												  
												2:{ cuePoint : 8,
													tag:"blank",
													text: " ",
												  },
											
												3:{ cuePoint : 9,
													tag:"blank",
													text: "The drain hose routes both nitrogen gas and vapor from the spray chamber to the drain bottle. The vapor is made up of mobile phase and sample."
												  },
												  
												4:{ cuePoint : 15,
													tag:"blank",
													text: "The rough pump exhaust contains traces of solvent, sample, and hydrocarbon pump fluid. For rough pumps with mist filters, the mist filter on the rough pump traps the majority of the pump oil vapor. It does not trap the traces of solvent and sample that may be present in the exhaust gases."
												  },
												  
												5:{ cuePoint : 23,
													tag:"blank",
													text: "Air needs to flow away from the instrument."
												  },
												  
												  
												6:{ cuePoint : 31,
													tag:"The spray chamber exhaust and the foreline pump exhaust are vented externally",
													text: "<span class='warning'>WARNING</span>User safety requires that the spray chamber exhaust and the rough pump exhaust are vented externally to the building and not re-circulated by the environmental control system. Exhaust gas venting must comply with all local environmental codes. Health hazards include chemical toxicity of solvents, samples, buffers, pump fluid vapor, and aerosolized biological samples."
												  },
												
												7:{ cuePoint : 54,
													tag:"blank",
													text: " "
												  },
												}
												}, // page
												
												{  
												title: "Exhaust venting" ,
												short_title: "blank" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'><span class='warning'>WARNING</span>Failure to vent the rough pump and spray chamber separately will void the warranty for the LC/MS. Agilent service representatives will not install an Agilent LC/MS until an adequate exhaust system is present and functioning. <br><br><span class='caution'>CAUTION</span>The spray chamber exhaust and rough pump exhaust must be vented using separate lengths of exhaust tubing. These may be connected into a common exhaust manifold. This is to minimize the chances of rough pump fluid vapor entering the spray chamber when drying gas is not flowing. If connecting to a common exhaust manifold, the source should be plumbed in upstream of where the rough pump exhaust is plumbed into the manifold.<br><br><span class='caution'>CAUTION</span> Your exhaust venting system must be able to handle the combined exhaust flow from the spray chamber and the rough pump. Refer the Site Preparation Checklist for the specifications for your system.<br><br><span class='caution'>CAUTION</span>Flow is continuous as long as the instrument is on. Both exhaust vents must be at or slightly below atmospheric pressure <br>(negative pressure). If a negative pressure vent is not available, the length of the tubing from the rough pump and the drain bottle to the vent should each not exceed 460 cm (180 inches).<br><br><span class='caution'>CAUTION</span>Positive pressure in the spray chamber exhaust tubing and drain bottle can affect instrument performance and may contribute to excessive background contaminant levels.</div></div>" ,
												details:{									
												1:{
												text: "Exhaust venting , WARNING , Failure to vent the rough pump and spray chamber separately will void the warranty for the 6500 Series Q-TOF LC/MS. Agilent service representatives will not install an Agilent 6500 Series Q-TOF LC/MS until an adequate exhaust system is present and functioning.  , CAUTION , The spray chamber exhaust and rough pump exhaust must be vented using separate lengths of exhaust tubing. These may be connected into a common exhaust manifold. This is to minimize the chances of rough pump fluid vapor entering the spray chamber when drying gas is not flowing. If connecting to a common exhaust manifold, the source should be plumbed in upstream of where the rough pump exhaust is plumbed into the manifold. , Your exhaust venting system must be able to handle the combined exhaust flow from the spray chamber and the rough pump. Refer the Site Preparation Checklist for the specifications for your system.,  Flow is continuous as long as the instrument is on. Both exhaust vents must be at or slightly below atmospheric pressure (negative pressure)If a negative pressure vent is not available, the length of the tubing from the rough pump and the drain bottle to the vent should each not exceed 460 cm (180 inches). , Positive pressure in the spray chamber exhaust tubing and drain bottle can affect instrument performance and may contribute to excessive background contaminant levels."
												},								 
												}
												}, // page
											]  //pageList
									}, // subChapter 
							}// subChapterList		
			}, // chapter
			
			5:{ 			
					chapterName : "Electrical requirements",
					iconPath : "images/submenuicon/Q-TOF/Electrical_Requirements.png",
					subChapterList : {				
								1:{
									subChapterName : "Electrical requirements",
									iconPath : "images/submenuicon/Q-TOF/Electrical_Requirements.png",
									submenu : true,
									pageList : [  
												{  
												title: "Voltage and power requirements" ,
												short_title: "Voltage and power requirements" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'>The customer is responsible for providing appropriate electrical power and power outlets for all components and accessories used with the LC/MS system. Power considerations include: <ul><li>Voltage ranges of major components</li><li>Power requirements of major component	</li><li>Single-phase power configurations</li><li>Power plugs, receptacles and cords</li></ul><p>The LC/MS system includes a wide-range power supply that can operate without reconfiguration.</p><p><span class='note'>NOTE</span> The LC/MS, LC, and data system each requires a separate branch circuit breaker.</p><p>Refer to the Site Preparation Checklist for details on exact voltage and power requirements for your instrument and pump. </P><div style='display: inline-block;'><div style='float:left;text-align: center;padding: 20px;border:1px solid #b3b3b3;margin-right:15px;'><img src='images/topic01/power_51.jpg'></div><div style='margin-bottom:20px;'><span class='caution'>CAUTION</span>If an instrument is being ordered from one location, but is to be installed in another location with different electrical power characteristics, a special note must be made on the order that the electrical power at the site is different from the standard electrical power in that country.</div></div><p>Power must meet the stated stability specifications. Use a line monitor to check the power stability. If the line power is unstable, it may be necessary to install a line conditioner.</p></div></div>",
												details:{									
												1:{
												text: "Voltage and power requirements , The customer is responsible for providing appropriate electrical power and power outlets for all of the components and accessories used with the 6500 Series Q-TOF LC/MS system. Power considerations include: , Voltage ranges of major components , Power requirements of major components , Single-phase power configurations , Power plugs, receptacles and cords , The Q-TOF LC/MS system includes a wide-range power supply that can operate without reconfiguration, however, the rough pump model must be configured for either of two voltage ranges of single-phase alternating current (AC).,Note that the LC/MS, LC, and data system each requires a separate branch circuit breaker.​, Refer to the Site Preparation Checklist for details on exact voltage and power requirements for your instrument and pump. , For instruments with ESI source, fluctuations not to exceed 10% of nominal supply voltage , For instruments with an AJS source, fluctuations not to exceed +10/-5% from the rated voltage"
												},								 
												}
												}, // page
												
												 
												{  
												title: "Voltage and power requirements" ,
												short_title: "blank" ,
												type: "video" ,
												path : "video/topic04/voltage_range_n_power_requirement.mp4" ,
												PdfPath : "pdf/topic03/voltage_range_n_power_requirement.pdf",
											
												details: {
													1:{ cuePoint : 0,
														tag:"Avoid sources of radio noise",
														text: "Do not install the LC/MS near appliances that can generate radio noise or interference, such as fluorescent lights, radios and televisions."
													  },
												
													2:{ cuePoint : 9,
														tag:"Plug the device into a different electrical outlet",
														text: "Each product listed requires a dedicated circuit. The LC/MS, LC, and Data system must each have a separate circuit breaker.  "
													  },
													  
													3:{ cuePoint : 28,
														tag:"blank",
														text: " "
													  }, 
													
													}
												}, // page
												
												{  
												title: "Power configurations" ,
												short_title: "Power configurations" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>Electrical power for the Agilent LC/MS may be delivered in either single-phase or 208-Wye configuration.<p> Refer to the Site Preparation Checklist for the primary voltage characteristics of each configuration. Correct grounding for the 208-Wye configuration must be verified by an electrician. The neutral wire cannot be used for safety grounding. </p><div style='display:inline-block;margin-bottom: 20px;'><div style='float:left;text-align: center;padding: 20px;border:1px solid #b3b3b3;margin-right:15px;'><img src='images/topic01/power_config.png'></div><div style='margin-bottom:20px;'>The ground wire should carry zero current except for ground-fault current or static electric discharge. The entire system should share an isolated, noise-free electrical ground that is connected to the main earth ground for the facility.</div></div><br><span class='warning'>WARNING</span>The power source to which you connect an Agilent LC/MS must be equipped with a protective earth contact (ground).<br><br><span class='warning'>WARNING</span>Do not interrupt the protective earth contact inside or outside the LC/MS or disconnect the protective earth terminal (ground).</div></div>" ,
												details:{									
												1:{
												text: "Power configurations , Electrical power for the Agilent LC/MS may be delivered in either single-phase or 208-Wye configuration., Refer to the Site Preparation Checklist for the primary voltage characteristics of each configuration. Correct grounding for the 208-Wye configuration must be verified by an electrician., The neutral wire cannot be used for safety grounding. The ground wire should carry zero current except for ground-fault current or static electric discharge., The entire system should share an isolated, noise-free electrical ground that is connected to the main earth ground for the facility., WARNING, The power source to which you connect an Agilent LC/MS must be equipped with a protective earth contact (ground)., Do not interrupt the protective earth contact inside or outside the LC/MS or disconnect the protective earth terminal (ground). "
												},								 
												}
												}, // page
												
												{  
												title: "Power plugs and cords" ,
												short_title: "Power plugs and cords" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>The LC/MS is supplied with an appropriate power cord(s) and plug for the country in which the order originates. The length of all LC/MS power cords is approximately 2.4 m (94 inches).<p>The data system components also include power cords with plugs appropriate for the country in which the order was placed. Power cord lengths for the data system components and accessories are approximately 2.3 m (90 inches).</p><p>“Power cords” in the Reference section shows the style of the plug for the cord that will ship to your country. Make sure that the power receptacles in your laboratory can accommodate this configuration. If needed, consult with your Agilent representative.</p><span class='caution'>CAUTION</span>If an instrument is being ordered from one location, but is to be installed in another location with different electrical power characteristics, advise your Agilent sales representative to make a note on your order of the electrical power characteristics for the location where the instrument will be installed.<br> <br> <div style='width:100%'><div style='width:72%;float:left'><span class='warning'>WARNING</span>Do not use extension cords with the Agilent LC/MS. Extension cords can be a safety hazard.</div><div style='float:left;text-align: center;padding: 15px;border:1px solid #b3b3b3'><img src='images/topic01/extension_cord.jpg'></div></div></div></div>",
												details:{									
												1:{
												text: "Power plugs and cords , The LC/MS is supplied with an appropriate power cord(s) and plug for the country in which the order originates., The length of all LC/MS power cords is approximately 2.4 m (94 inches). ,“Power cords” in the Reference section shows the style of the plug for the cord that will ship to your country. Make sure that the power receptacles in your laboratory can accommodate this configuration. If needed, consult with your Agilent representative., The data system components also include power cords with plugs appropriate for the country in which the order was placed. Power cord lengths for the data system components and accessories are approximately 2.3 m (91 inches). , CAUTION If an instrument is being ordered from one location, but is to be installed in another location with different electrical power characteristics, advise your Agilent sales representative to make a note on your order of the electrical power characteristics for the location where the instrument will be installed. , WARNING Do not use extension cords with the Agilent LC/MS. Extension cords can be a safety hazard."
												},								 
												}
												}, // page
												
												{  
												title: "Other electrical considerations" ,
												short_title: "Other electrical considerations" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>Additional electrical considerations include:<ul><li>Electromagnetic interference (EMI), such as is generated by NMRs, radio transmitters, and microwave links, may interfere with system performance.</li><li>Protect the system from static electricity by observing humidity and temperature requirements. Minimize the presence of non-conductive products such as carpets and vinyl floor tiles.</li><li>Install emergency-off pushbuttons that can disconnect power to the ventilation system and all electric equipment in the room except overhead lighting.</li><li>Separate convenience outlets should be provided for building maintenance and other appliances. Convenience outlets must be on circuits separate from the Q-TOF LC/MS system. Convenience outlets must share the normal building distribution ground, not the Q-TOF LC/MS system ground.</li><li>In areas where frequent power outages are experienced, Agilent recommends to install an uninterruptable power supply.​</li></ul></div></div>" ,
												details:{									
												1:{
												text: "Other electrical considerations , Additional electrical considerations include: , Electromagnetic interference (EMI), such as is generated by NMRs, radio transmitters, and microwave links, may interfere with system performance. , Protect the system from static electricity by observing humidity and temperature requirements. Minimize the presence of non-conductive products such as carpets and vinyl floor tiles. , Install emergency-off pushbuttons that can disconnect power to the ventilation system and all electric equipment in the room except overhead lighting. , Separate convenience outlets should be provided for building maintenance and other appliances. Convenience outlets must be on circuits separate from the Q-TOF LC/MS system. Convenience outlets must share the normal building distribution ground, not the Q-TOF LC/MS system ground. , In areas where frequent power outages are experienced, Agilent recommends to install an uninterruptable power supply.​ "
												},								 
												}
												}, // page
											]  //pageList
									}, // subChapter 
							}// subChapterList		
			}, // chapter
			
			6:{ 			
					chapterName : "Gas requirements",
					iconPath : "images/submenuicon/Q-TOF/Gas_Requirements.png",
					subChapterList : {				
								1:{
									subChapterName : "Gas requirements",
									iconPath : "images/submenuicon/Q-TOF/Gas_Requirements.png",
									submenu : true,
									pageList : [  
												{  
												title: "Nitrogen gas requirements" ,
												short_title: "Nitrogen gas requirements" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>The Agilent LC/MS requires large quantities of high-purity nitrogen for drying gas, nebulizing gas, sheath gas (for AJS source), collision cell gas (for LC/Q-TOF), and to pressurize the calibrant delivery system.<p>The 6560 Ion Mobility Q-TOF additionally requires ultrapure nitrogen for the drift gas at installation.​</p><span class='warning'>WARNING</span>Use only nitrogen for the drying and nebulizing gas. Use of air, oxygen, or other gases when combined with volatile solvents and high voltages in the spray chamber, could result in an explosion. Use of air, oxygen, or other gases may also cause deterioration of parts in the LC/MS and have a negative effect on instrument operation and sensitivity.<p>Due to the large volumes of nitrogen required for instrument operation, the use of a nitrogen generator (gas separator) or a large (160 liters or greater) dewar of liquid nitrogen is required. High pressure nitrogen bottles are not suitable for drying gas supply with the 6500 Series Q-TOF LC/MS Systems except for use as the collision cell gas supply.</p><p>Agilent Technologies offers several nitrogen gas generators well suited for use with the LC/MS. Check with your Agilent representative to purchase one of these generators.</p><span class='warning'>WARNING</span>Contact your gas supplier for handling and safety information for the gases you use. Compressed or liquefied gases can be dangerous.</div></div>" ,
												details:{									
												1:{
												text: "Nitrogen gas requirements , The Agilent LC/MS requires large quantities of high-purity nitrogen for drying gas, nebulizing gas, sheath gas (for AJS source), collision cell gas (for LC/Q-TOF), and to pressurize the calibrant delivery system. , The 6560 Ion Mobility Q-TOF additionally requires ultrapure nitrogen for the drift gas at installation.​ , WARNING Use only nitrogen for the drying and nebulizing gas. Use of air, oxygen, or other gases when combined with volatile solvents and high voltages in the spray chamber, could result in an explosion. Use of air, oxygen, or other gases may also cause deterioration of parts in the LC/MS and have a negative effect on instrument operation and sensitivity. , Due to the large volumes of nitrogen required for instrument operation, the use of a nitrogen generator (gas separator) or a large (160 liters or greater) dewar of liquid nitrogen is required. High pressure nitrogen bottles are not suitable for drying gas supply with the 6500 Series Q-TOF LC/MS Systems except for use as the collision cell gas supply. , Agilent Technologies offers several nitrogen gas generators well suited for use with the LC/MS. Check with your Agilent representative to purchase one of these generators., WARNING Contact your gas supplier for handling and safety information for the gases you use. Compressed or liquefied gases can be dangerous."
												},								 
												}
												}, // page
												
 
												{  
												title: "Nitrogen purity" ,
												short_title: "Nitrogen purity" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'><p>The nitrogen gas used for drying gas must be free of contaminants. Nitrogen generators and nitrogen dewars are commonly used as the primary nitrogen source because they are the best to mitigate common contaminants that interfere with LC/MS. Nitrogen generators offer the advantages of less frequent maintenance and source gas filtration but are limited in their purity. Dewars generally offer a higher purity but do not inherently filter the source gas. Dewars also have a finite volume, which results in more frequent maintenance.</p> <div style='width:102px;text-align:center;float:left;margin-right:10px;margin-bottom:10px;border:1px solid #b3b3b3;'><img src='images/topic02/Nitrogen_purity.jpg'></div><p style='padding-top:20px;'>One or more high-capacity gas conditioner is supplied with the Agilent LC/MS. Its primary function is to remove hydrocarbon contamination from the nitrogen before it reaches the LC/MS. Refer to the Site Preparation Checklist for nitrogen flow requirements for your system. This conditioner has 1/4-inch Swagelok fittings.</p><br><br><p><span class='note'>NOTE</span> Use of high-pressure nitrogen bottles is not supported due the high usage rate.​</p> <table><tr><th class='txt_center'>Source</th><th class='txt_center' width='400px'>Purity</th><th class='txt_center'>Gas Pressure</th> </tr>  <tr valign='top'> <td>Liquid nitrogen dewar or Nitrogen generator</td><td>>95.0% and hydrocarbon-free (less than 1 ppm, with the remaining gas being oxygen and trace argon)</td><td>5.5 to 6.8 bar<br>(80 to 100 PSI)<br>(550 to 690 kPa)​</td> </tr> </table></div></div>" ,
											details:{									
												1:{
												text: "Nitrogen purity , The nitrogen gas used for drying gas must be free of contaminants.  Purity specifications vary according to the source of the nitrogen. This is due to the different types of contaminants common to different nitrogen sources. , When using a nitrogen generator, oxygen is the primary contaminant of the gas supply. Oxygen has less impact on LC/MS sensitivity, and in some operating modes and certain applications may enhance sensitivity in small concentrations. Therefore, the purity specification for gas from a nitrogen generator can be less stringent. , One or more high-capacity gas conditioner is supplied with the Agilent LC/MS. Its primary function is to remove hydrocarbon contamination from the nitrogen before it reaches the Q-TOF system. This conditioner has 1/4-inch Swagelok fittings. , NOTE Use of high-pressure nitrogen bottles is not supported due to high usage rate. , Source , Purity , Gas Pressure , Flow , Nitrogen generator, Liquid nitrogen dewar or Nitrogen generator, 95% pure 1 or better and hydrocarbon free 2 , 5.5 to 6.8 bar (80 to 100 psi)​ (552 to 689 kpa)​ "
												},								 
												}
												}, // page
												
												{  
												title: "Collision cell reagent gas purity (for LC/Q-TOF only)" ,
												short_title: "Collision cell reagent gas purity <br>(for LC/Q-TOF only)" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'> The collision cell gas must be a higher purity than the gas used as drying gas. You can use high-pressure bottled nitrogen or high-pressure bottled argon as the collision cell reagent gas. <p>A high-capacity gas conditioner for collision cell reagent gas is supplied with the LC/MS. Its primary function is to remove hydrocarbon contamination from the nitrogen before it reaches the collision cell. This conditioner has 1/4-inch Swagelok fittings.</p><p>The supplied conditioner is to be used with nitrogen only. If you use argon, make sure you purchase an appropriate gas conditioner for argon.</p><p><span class='note'>NOTE</span>Nitrogen is required for installation performance verification.</p> <p> Agilent does not support the use of a separate regulator to split the drying gas flow, due to the uncertainty in the purity of the drying gas source.</p> <table><tr><th class='txt_center'>Source</th><th style='width: 200px;' class='txt_center'>Purity</th><th class='txt_center'>Gas Pressure</th><th class='txt_center'>Flow</th></tr><tr> <td>High-pressure bottled nitrogen or </br>high-pressure bottled argon</td><td>>99.998% and hydrocarbon-free (less than 1 ppm)  </td><td> 5.5 to 6.8 bar <br>(80 to 100 PSI)<br>(550 to 690 kPa)​</td><td>Up to 1 mL/minute</td></tr>  </table></div></div>" ,
												details:{									
												1:{
												text: "Collision cell reagent gas purity ,  The collision cell gas must be a higher purity than the gas used as drying gas. You can use high-pressure bottled nitrogen as the collision cell reagent gas. The minimum requirements are: , 99.999% purity or better , Hydrocarbon-free , Gas pressure of 1 to 2 bar (15 to 30 psi) (103 to 207 kpa) , The typical flow is up to 1 mL/minute. , A high-capacity gas conditioner for collision cell reagent gas is supplied with the 6000 series LC/MS. Its primary function is to remove hydrocarbon contamination from the nitrogen before it reaches the LC/MS system. This conditioner has 1/4-inch Swagelok fittings. , The supplied conditioner is to be used with nitrogen only. , For 6500 Series Q-TOF LC/MS, you can use argon gas instead of nitrogen, but nitrogen is required for installation performance verification. If you use argon, make sure you purchase an appropriate gas conditioner for argon. , Agilent does not support the use of a separate regulator to split the drying gas flow, due to the uncertainty in the purity of the drying gas source. , Source , Purity , Gas Pressure , Flow , High-pressure bottled nitrogen or high-pressure bottled argon	>99.998% and hydrocarbon-free (less than 1 ppm)	5.5 to 6.8 bar (80 to 100 PSI), (550 to 690 kPa)​,Up to 1 mL/minute "
												},								 
												}
												}, // page
												
												{  
												title: "Drift tube gas requirement for IM-QTOF" ,
												short_title: "Drift tube gas requirement for IM-QTOF" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>The drift tube gas must be a higher purity than the gas used as drying gas. <p>A high-capacity gas conditioner for drift tube reagent gas is supplied with the IM-QTOF. Its primary function is to remove hydrocarbon contamination from the nitrogen before it reaches the drift tube. This conditioner has 1/4-inch Swagelok fittings.</p><p>Splitting the drying gas flow using a separate regulator is not supported due to the uncertainty in the purity of the drying gas source especially when using a nitrogen generator.</p><table><tr> <th class='txt_center'>Purity</th><th class='txt_center'>Gas Pressure</th><th class='txt_center'>Flow</th></tr><tr> <td>99.998% pure or better and hydrocarbon-free (less than 1 ppm)</td><td> 5.5 - 6.6 bar​ <br>(80 to 100 psi)</td><td>Up to 2 L/min</td></tr> </table></div></div>" ,
												details:{									
												1:{
												text: "Drift tube gas requirement for ion mobility Q-TOF systems , The drift tube gas must be a higher purity than the gas used as drying gas. The minimum purity for any drift tube gas is 99.999% with less than 0.2 parts per million hydrocarbon contamination. , A high-capacity gas conditioner for drift tube reagent gas is supplied with the 6500 Series Q-TOF LC/MS. Its primary function is to remove hydrocarbon contamination from the nitrogen before it reaches the Q-TOF system. This conditioner has 1/4-inch Swagelok fittings. , Splitting the drying gas flow using a separate regulator is not supported due to the uncertainty in the purity of the drying gas source especially when using a nitrogen generator. , Source , Purity , Gas Pressure , Flow , High Pressure bottled Nitrogen , 99.998% pure or better and hydrocarbon-free 1  , 5.5 - 6.6 bar (80 to 100 psi) , Up to 2 L/min "
												},								 
												}
												}, // page
	
												{  
												title: "Nitrogen regulators, tubing, and fittings" ,
												short_title: "Nitrogen regulators, tubing, and fittings" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div style='float:left;margin:0 15px 0 15px'><img src='images/topic01/Regulator.jpg'></div><div class='textContainer' style='width:72%'>You must supply appropriate regulators for your sources of nitrogen gas. The regulators must be able to supply gas in the specified pressure ranges.<p>The regulator for the drying gas must have one outlet with 1/4- inch Swagelok fittings. Gas generators have built-in regulators so they do not require an external regulator. A dewar of liquid nitrogen typically requires a regulator (see the dewar manufacturer's literature for specifics).</p><p> Nitrogen from a house supply requires a single-stage regulator if the supply is at a pressure higher than the specified range. Bottled, compressed nitrogen typically requires a dual-stage regulator. See the Agilent Chemical Analysis Columns and Supplies Catalog <a href='https://www.agilent.com/' target='blank'>(www.agilent.com)</a> for dual-stage regulators available from Agilent Technologies.</p></div><div class='textContainer textContainer_100'><p>The 6500 Series Q-TOF LC/MS is supplied with 300 centimeters of heavy-wall 1/4-inch PTFE tubing to connect the nitrogen supply to the 6500 Series Q-TOF LC/MS. You may need to supply additional heavy-wall 1/4-inch PTFE tubing if the nitrogen supply is located farther from the Q-TOF system. You can substitute 1/4-inch medical-grade polypropylene tubing for the PTFE tubing. You must supply fittings, ferrules, and connectors of a Swagelok design for the 1/4-inch tubing.</p></div></div>" ,
												details:{									
												1:{
												text: "Nitrogen regulators, tubing, and fittings , You must supply appropriate regulators for your sources of nitrogen gas. The regulators must be able to supply gas in the specified pressure ranges. , The regulator for the drying gas must have one outlet with 1/4- inch Swagelok fittings. Gas generators have built-in regulators so they do not require an external regulator. A dewar of liquid nitrogen typically requires a regulator (see the dewar manufacturer's literature for specifics). , Nitrogen from a house supply requires a single-stage regulator if the supply is at a pressure higher than the specified range. Bottled, compressed nitrogen typically requires a dual-stage regulator. See the Agilent Chemical Analysis Columns and Supplies Catalog (5988-4970EN) for dual-stage regulators available from Agilent Technologies. , The 6500 Series Q-TOF LC/MS is supplied with 300 centimeters of heavy-wall 1/4-inch PTFE tubing to connect the nitrogen supply to the 6500 Series Q-TOF LC/MS. You may need to supply additional heavy-wall 1/4-inch PTFE tubing if the nitrogen supply is located farther from the Q-TOF system. You can substitute 1/4-inch medical-grade polypropylene tubing for the PTFE tubing. You must supply fittings, ferrules, and connectors of a Swagelok design for the 1/4-inch tubing."
												},								 
												}
												}, // page
											]  //pageList
									}, // subChapter 
							}// subChapterList		
			}, // chapter
			
			7:{ 			
					chapterName : "Laboratory supply requirements",
					iconPath : "images/submenuicon/Q-TOF/Laboratory_Supply_Requirements.png",
					subChapterList : {				
							1:{
									subChapterName : "Laboratory supply requirements",
									iconPath : "images/submenuicon/Q-TOF/Laboratory_Supply_Requirements.png",
									submenu : true,
									pageList : [  
												{  
												title: "Operating supplies" ,
												short_title: "Operating supplies" ,
												type: "tools" ,
												content:"<div id='dataContainer'><div class='textContainer textContainer_100'>Agilent recommends that the highest grade solvents available be used. Lower purity grades will result in higher background levels. Order your solvents from <a href='https://www.agilent.com/'>www.agilent.com</a></div></div>",
												details: {									
														1:{ imagePath: "images/topic01/tools/Acetonitrile.jpg",
															text : "LC/MS-grade acetonitrile, pesticide residue analysis",
															Part_number : "G2453-85050"
														  },
														2 :{ imagePath: "images/topic01/tools/Methonol.jpg",
															text : "LC/MS-grade Methanol",
															Part_number : "5190-6896"
														  },
														3 :{ imagePath: "images/topic01/tools/LC_MS_grade_water.jpg",
															text : "LC/MS Water (4 Liter)",
															Part_number : "5190-6897"
														  },
														4 :{ imagePath: "images/topic01/tools/Ammonium_formate.jpg",
															text : "Ammonium formate, 97% purity or better",
															Part_number : "G1946-85021"
														  },
														5 :{ imagePath: "images/topic01/tools/Acetic_acid.jpg",
															text : "Acetic acid, 99.7% minimum purity, LC/MS grade recommended",
															
														  },
														6 :{ imagePath: "images/topic01/tools/Formic_acid.jpg",
															text : "Formic acid, 95% minimum purity, LC/MS grade recommended",
															Part_number : "G2453-85060 "
														  },
														7 :{ imagePath: "images/topic01/tools/isopropyl_alcohol.png",
															text : "Isopropyl alcohol, minimum 99% purity. LC/MS grade",
															
														  },
												}
												}, // page
												
												 
												
												{  
													title: "Fume hood" ,
													short_title: "Fume hood" ,
													type: "text_image" ,
													content: "<div id='dataContainer'><div class='textContainer textContainer_100'>An auxiliary work space and fume hood are needed for some maintenance procedures.</div><div class='imageContainer_80'><img src='images/topic01/fume_hood.jpg'></div>",
													details:{									
													1:{
													text: "Fume hood , An auxiliary work space and fume hood are needed for some maintenance procedures."
													},								 
													}
												}, // page
												
												  
											]  //pageList
									}, // subChapter 
							}// subChapterList		
			}, // chapter
	
			8:{ 			
					chapterName : "Delivery and installation",
					iconPath : "images/submenuicon/Delivery_and_Installation.png",
					subChapterList : {
						1:{ 
								subChapterName : "Delivery and installation",
								iconPath : "images/submenuicon/Delivery_and_Installation.png",
								submenu : true,
								pageList : [
											{  
												title: "Delivery and unloading" ,
												short_title: "Delivery and unloading" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='imageContainer_50' style='margin-right:12px;width: 290px;float: left; margin-bottom: 15px;'><img src='images/topic01/Forklift.jpg'></div><div class='textContainer textContainer_50'>The  Agilent system shipping containers are large and very heavy. Refer to the Site Preparation Checklist for the dimensions and weight of the base unit and flight assembly shipping containers. Additional shipping containers contain the Agilent system shipping kit and PC data system.<p>The shipping containers require a loading dock and a forklift or similar lifting device. If no loading dock and/or suitable lifting device is available, the containers cannot be removed from the delivery truck. If you make prior arrangements with your Agilent service representative, the system can be delivered in a lift-gate truck. This removes the need for a loading dock, but a lifting device is still required to move the containers.</p></div><div class='textContainer textContainer_100'><span class='caution'>CAUTION</span>The shipping containers must be kept upright at all times to prevent damage to the instrument. All doorways, hallways, floors, and elevators must be able to accommodate the largest, heaviest container.<br><br> </div></div>",
												details: {										
													1:{
														text: "Delivery and unloading , The Agilent system shipping containers are large and very heavy. Refer to the Site Preparation Checklist for the dimensions and weight of the base unit and flight assembly shipping containers. Additional shipping containers contain the Agilent system shipping kit and PC data system. , The shipping containers require a loading dock and a forklift or similar lifting device. If no loading dock and/or suitable lifting device is available, the containers cannot be removed from the delivery truck. If you make prior arrangements with your Agilent service representative, the system can be delivered in a lift-gate truck. This removes the need for a loading dock, but a lifting device is still required to move the containers. , CAUTION The shipping containers must be kept upright at all times to prevent damage to the instrument. All doorways, hallways, floors, and elevators must be able to accommodate the largest, heaviest container.  " 
														},								 
													
													
													}
											},
		
											{  
												title: "Inspection" ,
												short_title: "Inspection" ,
												type: "video" ,
												path : "video/topic02/Inspection.mp4" ,
												PdfPath : "pdf/topic03/Inspection.pdf",
												details: 
														{
														
														1:{ cuePoint : 4,
														tag:"Examination of shipping containers",
														text: "Once the shipping containers are unloaded, examine them for any obvious external damage."
														},
														
														2:{ cuePoint :13,
														tag:"Apparent damage - subject to inspection and test",
														text: "If any of the containers appear damaged, note on the carrier's bill of lading that there is: Apparent damage - subject to inspection and test. "
														},
														
														3:{ cuePoint :21,
														tag:"Warranty condition",
														text: "Do not open any of the shipping containers unles a representative of Agilent Technologies is present. Opening any of the containers without an Agilent Technologies representative being present will void the receiving warranty on the Instrument."
														},
														
													}
											},
											
											{  
											title: "Storage" ,
											short_title: "Storage" ,
											type: "text_image" ,
											content: "<div id='dataContainer'><div class='textContainer textContainer_100'>It is your responsibility to store the containers until installation. If your site does not have adequate storage space, the containers will be stored at your expense in a bonded warehouse. Allow space for data system and accessory containers too.<p>The environment in the storage area should be between 5°C and 50°C (41°F and 122°F), 20% to 80% relative humidity, non-condensing and non-corrosive.</p><p>There are chemicals that are shipped with the system that may also require refrigeration between 4°C and 8°C. Additionally, some of these chemicals should not be exposed to temperatures below 5°C (41°F)</p></div></div>" ,
											details: {										
												1:{
													text: "Storage , It is your responsibility to store the containers until installation. If your site does not have adequate storage space, the containers will be stored at your expense in a bonded warehouse. Allow space for data system and accessory containers too. , The environment in the storage area should be between 5°C and 50°C (41°F and 122°F), 20% to 80% relative humidity, non-condensing and non-corrosive. , There are chemicals that are shipped with the system that may also require refrigeration between 4°C and 8°C. Additionally, some of these chemicals should not be exposed to temperatures below 5°C (41°F)" 
													},								 
												
												
												}
											},
											
											{  
											title: "Unpacking" ,
											short_title: "Unpacking" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'>Supplies that require refrigeration are shipped separately from the instrument. Open and refrigerate immediately upon delivery.​<p>Do not open any other shipping containers until an Agilent representative is present to verify the contents of each container as it is unpacked. The actual shipping containers become your property and should not be returned to Agilent Technologies.​</p><p>If the product is coming from a cold storage environment, allow time for thermal equilibration to room temperature before opening the shipping containers. This will avoid exposing the instrument to condensing humidity.</p></div></div>" ,
											details: {										
												1:{
													text: "Supplies that require refrigeration are shipped separately from the instrument. Open and refrigerate immediately upon delivery.​,Do not open any other shipping containers until an Agilent representative is present to verify the contents of each container as it is unpacked. The actual shipping containers become your property and should not be returned to Agilent Technologies.​,If the product is coming from a cold storage environment, allow time for thermal equilibration to room temperature before opening the shipping containers. This will avoid exposing the instrument to condensing humidity." 
													},								 
												
												
												}
											},
											
											{  
												title: "Unpacking" ,
												short_title: "blank" ,
												type: "video" ,
												path : "video/topic04/Unpacking.mp4" ,
												PdfPath : "pdf/topic03/Unpacking.pdf",
												details: 
														{
														
														1:{ cuePoint : 5,
														tag:"Allow time for thermal equilibration to room temperature",
														text: "If the product is coming from a cold storage environment, allow time for thermal equilibration to room temperature before opening the shipping containers. This will avoid exposing the instrument to condensing humidity."
														},
														
														2:{ cuePoint :14,
														tag:"Warranty condition",
														text: "Do not open any shipping containers until an Agilent representative is present. Warranty claims for missing items will not be honored unless an Agilent representative is present to verify the contents of each container as it is unpacked."
														},
														
														3:{ cuePoint :29,
														tag:"blank",
														text: "The actual shipping containers become your property and should not be returned to Agilent Technologies."
														},
														
													}
											},
											
											{  
											title: "Installation" ,
											short_title: "Installation" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'>Once the installation has begun, it should progress in a timely manner to completion. Delays due to inadequate site preparation could cause loss of instrument use during the warranty period. In extreme cases, Agilent Technologies may ask to be reimbursed for the additional time required to complete the installation.<p>The LC/MS base unit is too heavy to be lifted by one person. At least four people must be available to help lift the LC/MS base unit onto the laboratory bench.</p><p>The primary user of the LC/MS should be present during installation to receive familiarization instruction from the Agilent service representative.</p></div></div>" ,
											details: {										
												1:{
													text: "Installation , Once the installation has begun, it should progress in a timely manner to completion. Delays due to inadequate site preparation could cause loss of instrument use during the warranty period. In extreme cases, Agilent Technologies may ask to be reimbursed for the additional time required to complete the installation. , The LC/MS base unit is too heavy to be lifted by one person. At least four people must be available to help lift the LC/MS base unit onto the laboratory bench. , The primary user of the LC/MS should be present during installation to receive familiarization instruction from the Agilent service representative." 
													},								 
												
												
												}
											},
											
											{  
												title: "Verification" ,
												short_title: "Verification" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'><div style='display:inline-block;'><div style='float:left;text-align: center;padding: 10px;border:1px solid #b3b3b3;margin-right:15px;line-height:0;'><img src='images/topic01/check_list.jpg'></div><div>The final step in the installation process is system verification. Your Agilent service representative will test the system against Agilent standards as documented in the TOF or Q-TOF installation guide or in the installation guides for the LC/MS accessories you have purchased.</div></div><p>As part of verification, the Agilent service representative will not test your system against your standards or samples. Furthermore, the Agilent Customer Engineer will not set up your laboratory procedures. Assistance with laboratory procedures can be obtained from your local Agilent Applications Engineer (AE) on a consulting basis at an additional cost.</p></div></div>" ,
												details: {										
													1:{
														text: "Verification , The final step in the installation process is system verification. Your Agilent service representative will test the system against Agilent standards as documented in theTOF or Q-TOF installation guide or in the installation guides for the LC/MS accessories you have purchased. , The Agilent service representative will not test your system against your standards or samples. Furthermore, the Agilent Customer Engineer will not set up your laboratory procedures. Assistance with laboratory procedures can be obtained from your local Agilent Applications Engineer (AE) on a consulting basis at an additional cost." 
														},								 
													
													
													}
											},
											
											{  
												title: "Recycling" ,
												short_title: "Recycling" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'><div style='float:left'><img src='images/topic01/recycle.jpg' style='width:50px;margin-right:10px;'></div><div>For recycling, contact your local Agilent sales representative office.</div></div></div>" ,
												details: {										
													1:{
														text: "Recycling , For recycling, contact your local Agilent sales representative office." 
														},								 
													
													
													}
											},
					
										]	
							},//subChapter
	
								
					}//subChapterList			
			}, // chapter 
		 
				9:{ 			
				chapterName : "Reference",
				iconPath : "images/submenuicon/Reference.png",
				subChapterList : {				
							1:{
								subChapterName : "Reference",
								iconPath : "images/submenuicon/no_image.png",
								submenu : true,
								pageList : [  
											{  
													title: "Power cords" ,
													short_title: "Power cords" ,
													type: "text_image" ,
													content:'<div id="dataContainer"><div class="textContainer textContainer_100">Following are the power cords (IEC C19) available for the Agilent LC/TOF and LC/Q-TOF. See the section Electrical Requirements for information about ensuring that the correct power cord is supplied with your system.<h4>US and Canada, NEMA 6-15P (Agilent p/n 8120-8623)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/pc1.jpg"></img></div><p>An alternative power cord (G1946-60066) with a NEMA L6-30P connector is available at extra cost. It is useful if a twist-lock plug is desired.</p><h4>European Power, CEE 7/7 (Agilent p/n 8120-8621)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic03/pc2.jpg"></img></div></div></div>',
													
													details:{									
														1:{
														text: "Power cords , Following are the power cords (IEC C19) available for the Agilent LC/TOF and LC/Q-TOF. See the section Electrical Requirements for information about ensuring that the correct power cord is supplied with your system. , US and Canada, NEMA 6-15P (Agilent p/n 8120-8623) , An alternative power cord (G1946-60066) with a NEMA L6-30P connector is available at extra cost. It is useful if a twist-lock plug is desired. , European Power, CEE 7/7 (Agilent p/n 8120-8621) , UK / Hong Kong / Malaysia / Singapore, BS 1363 (Agilent p/n 8120-8620)"
														}
													}, // pages
												},
												
												{  
												title: "Power cords" ,
												short_title: "blank" ,
												type: "text_image" ,
												content:'<div id="dataContainer"><div class="textContainer textContainer_100"><h4>UK / Hong Kong / Malaysia / Singapore, BS 1363 (Agilent p/n 8120-8620)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/pc3.jpg"></img></div><h4>Switzerland / Denmark, IEC 309 (Agilent p/n 8120-8622)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/pc4.jpg"></img></div><h4>Australia, (Agilent p/n 8120-8619)</h4><h4>China, (Agilent p/n 8121-0070)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/pc5.jpg"></img></div></div></div>',
												
												details:{									
													1:{
													text: "Power cords , Switzerland / Denmark, IEC 309 (Agilent p/n 8120-8622) , Australia, (Agilent p/n 8120-8619) , China, (Agilent p/n 8121-0070)"
													}
												}, // pages
												},
												
												{  
												title: "Power cords" ,
												short_title: "blank" ,
												type: "text_image" ,
												content:'<div id="dataContainer"><div class="textContainer textContainer_100"><h4>India / South Africa, BS 546 (Agilent p/n 8121-0710)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/India_South Africa.jpg"></img></div><h4>Israel, SI 32 (Agilent p/n 8121-0161)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/Israel.jpg"></img></div><h4>Japan NEMA L6-20P (Agilent p/n 8120-6903)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/japan.jpg"></img></div></div></div>',						
												details:{									
													1:{
													text: "Power cords , India / South Africa, BS 546 (Agilent p/n 8121-0710) , Israel, SI 32 (Agilent p/n 8121-0161) , Japan NEMA L6-20P (Agilent p/n 8120-6903)"
													}
												}, // pages
												},
												
												{  
												title: "Power cords" ,
												short_title: "blank" ,
												type: "text_image" ,
												content:'<div id="dataContainer"><div class="textContainer textContainer_100"><h4>Taiwan / South America, NEMA 6-20P (Agilent p/n 8120-6360)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic03/pc7.jpg"></img></div><h4>Korea, (Agilent p/n 8121-1222)</h4><h4>(Not Shown)</h4><h4>Thailand, (Agilent p/n 8121-1301)</h4><h4>(Not Shown)</h4></div></div>',
												
												details:{									
													1:{
													text: "Power cords , Taiwan / South America, NEMA 6-20P (Agilent p/n 8120-6360) , Korea, (Agilent p/n 8121-1222) , (Not Shown) , Thailand, (Agilent p/n 8121-1301) , (Not Shown)"
													}
												}, // pages
												},
											
											]  //pageList
								}, // subChapter 
						}// subChapterList		
		}, // chapter
			} // chapterList	
	  },
	  }//topic
	  
	  
	
	  
	