﻿var topic3 = {  
topicInfo:{ 	
		topicId : 1,
		topicName : "6400 Series LC/TQ", 
		iconPath : "images/submenuicon/LCTQ/LCTQ.png",
		small_iconPath : "images/sprite/no_image.png",
		chapterList:{
			1:{ 			
				chapterName : "Important",
				iconPath : "images/submenuicon/important_icon.png",
				subChapterList:{
					1:{
						subChapterName : "Important",
						iconPath : "images/submenuicon/no_image.png",
						submenu : true,
						pageList : [	
									{  
									title: "Warranty" ,
									short_title: "Warranty" ,
									type: "text_image" ,
									content:'<div id="dataContainer"><div class="textContainer textContainer_100">The material contained in this document is provided "as is", and is subject to being changed, without notice, in future editions. Further, to the maximum extent permitted by applicable law, Agilent disclaims all warranties, either express or implied, with regard to this manual and any information contained herein, including but not limited to the implied warranties of merchantability and fitness for a particular purpose.<p> Agilent shall not be liable for errors or for incidental or consequential damages in connection with the furnishing, use, or performance of this document or of any information contained herein. Should Agilent and the user have a separate written agreement with warranty terms covering the material in this document that conflict with these terms, the warranty terms in the separate agreement shall control.</p></div></div>',
									details: {									
											1:{
												text: ' Warranty , The material contained in this document is provided "as is", and is subject to being changed, without notice, in future editions. Further, to the maximum extent permitted by applicable law, Agilent disclaims all warranties, either express or implied, with regard to this manual and any information contained herein, including but not limited to the implied warranties of merchantability and fitness for a particular purpose. , Agilent shall not be liable for errors or for incidental or consequential damages in connection with the furnishing, use, or performance of this document or of any information contained herein. Should Agilent and the user have a separate written agreement with warranty terms covering the material in this document that conflict with these terms, the warranty terms in the separate agreement shall control. '
											  },								 
											}
									},
										
									{  
									title: "Safety notices" ,
									short_title: "Safety notices" ,
									type: "text_image" ,
									content:'<div id="dataContainer"><div class="textContainer textContainer_100"><span class="caution">CAUTION</span> <br><br>A CAUTION notice denotes a hazard. It calls attention to an operating procedure, practice, or the like that, if not correctly performed or adhered to, could result in damage to the product or loss of important data. Do not proceed beyond a CAUTION notice until the indicated conditions are fully understood and met.<br><br><span class="warning">WARNING</span><br><br>A WARNING notice denotes a hazard. It calls attention to an operating procedure, practice, or the like that, if not correctly performed or adhered to, could result in personal injury or death. Do not proceed beyond a WARNING notice until the indicated conditions are fully understood and met.<p>For more information about safety and conformity, refer to the <a href="https://www.agilent.com/cs/library/usermanuals/public/G1960-90113_6000_Safety.pdf" target="#" style="color:rgb(0, 133, 213)">6000 Series LC/MS Safety Guide</a>.</p></div></div>',
									details: {									
											1:{
												text: " Safety notices , CAUTION , A CAUTION notice denotes a hazard. It calls attention to an operating procedure, practice, or the like that, if not correctly performed or adhered to, could result in damage to the product or loss of important data. Do not proceed beyond a CAUTION notice until the indicated conditions are fully understood and met. , A WARNING notice denotes a hazard. It calls attention to an operating procedure, practice, or the like that, if not correctly performed or adhered to, could result in personal injury or death. Do not proceed beyond a WARNING notice until the indicated conditions are fully understood and met. , For more information about safety and conformity, refer to the 6000 Series LC/MS Safety Guide."
											  },								 
											}
									},
									{  
										title: "Overview" ,
										short_title: "Overview" ,
										type: "text_image" ,
										content : '<div id="dataContainer"><div class="textContainer textContainer_100">This section describes how to properly prepare your site for a new Agilent LC/MS instrument. Follow these instructions carefully as delays due to improper site preparation may result in loss of instrument use during the warranty period.<p>Before the 6400 Series LC/TQ system can be installed, the site must be properly prepared. Site preparation includes, but is not limited to, ensuring that adequate facilities are available. Among the site requirements are:<div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/power_51.jpg"></img></div><p style="float:left;">Adequate electrical power is available at the correct voltages and frequencies.</p><div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/Envorment.jpg"></img></div><p style="float:left;">Environmental control systems are adequate to maintain a correct, stable operating environment.</p><div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/Dry_nitrogen_gas.jpg"></img></div><p style="float:left;">An adequate source of clean, dry nitrogen gas.<br> An adequate source of ultrapure nitrogen for collision cell gas.</p><div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/venting.jpg"></img></div><p style="float:left;">Adequate exhaust venting.</p><div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/Paper.jpg"></img></div><p style="float:left;margin:15px 10px 0px 0px;">Supplies necessary for instrument operation are available, including solvents, carrier and reagent gases, and printer paper.</p> </div><div class="textContainer textContainer_100"> <p>Refer to the Site Preparation Checklist for specific requirements.​</p></div></div>' ,
										details: {										
											1:{
												text: "Overview , This section describes how to properly prepare your site for a new 6400 Series LC/TQ. Follow these instructions carefully as delays due to improper site preparation may result in loss of instrument use during the warranty period. , Before the 6400 Series LC/TQ system can be installed, the site must be properly prepared. Site preparation includes, but is not limited to, ensuring that adequate facilities are available. Among the site requirements are: , Adequate electrical power is available at the correct voltages and frequencies. , Environmental control systems are adequate to maintain a correct, stable operating environment. ,An adequate source of clean, dry nitrogen gas., An adequate source of ultrapure nitrogen for collision cell gas., Supplies necessary for instrument operation are available, including solvents, carrier and reagent gases, and printer paper.,Refer to the Site Preparation Checklist for specific requirements.​" 
												},								 
											
											}
										},
										{  
										title: "Overview" ,
										short_title: "blank",
										type: "text_image" ,
										content : '<div id="dataContainer"><div class="textContainer textContainer_100">Delays due to inadequate site preparation could cause loss of instrument use during the warranty period. In extreme cases, Agilent Technologies may ask to be reimbursed for the additional time required to complete the installation. <p><i>Agilent Technologies provides service during the warranty period and under maintenance agreements only if the specified site requirements are met.</i></p></div></div>' ,
										details: {										
											1:{
												text: " Overview , Delays due to inadequate site preparation could cause loss of instrument use during the warranty period. In extreme cases, Agilent Technologies may ask to be reimbursed for the additional time required to complete the installation. , Agilent Technologies provides service during the warranty period and under maintenance agreements only if the specified site requirements are met." 
												},								 
											
											}
										},
									
								  ]	
					},// subchapter	  
					
				} // subchapter List 			
			}, // chapter 
			2:{ 			
				chapterName : "General information",
				iconPath : "images/submenuicon/General_Information.png",
				subChapterList:{
					1:{
						subChapterName : "General information",
						iconPath : "images/submenuicon/General_Information.png",
						submenu : false,
						pageList : [	
									{  
									title: "Instrument identification" ,
									short_title: "Instrument identification" ,
									type: "text_image" ,
									content:'<div id="dataContainer"><div class="textContainer textContainer_100">Each Agilent LC/MS is identified by a unique 10-character serial number. This serial number is located on a label on the lower right front corner of the instrument. When corresponding with Agilent Technologies about your instrument, be sure to include the model number and the full 10-character serial number.</div><div class="imageContainer imageContainer_100"><img src="images/topic04/instrument_Serial.png"></img></div></div>',
									details: {									
											1:{
												text: "Each Agilent LC/MS is identified by a unique 10-character serial number. This serial number is located on a label on the lower right front corner of the instrument. When corresponding with Agilent Technologies about your instrument, be sure to include the model number and the full 10-character serial number."
											  },								 
											}
									},
							
										
								  ]	
						} // subchapter	  
					} // subchapter List 			
			}, // chapter 
		 
			3:{ 			
				chapterName : "Lab space requirements",
				iconPath : "images/submenuicon/LCTQ/Lab_Space_Requirements.png",
				subChapterList : {
					1:{ 
							subChapterName : "Lab space requirements",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [
								            {  
											title: "Bench requirement" ,
											short_title: "Bench requirement" ,
											type: "text_image" ,
											content : '<div id="dataContainer"><div class="textContainer textContainer_100">Supporting benches for the 6400 Series LC/TQ system are available from Agilent. Contact your Agilent representatives for ordering information on the appropriate bench for your lab.<br>​<br>​<span class="note">NOTE</span>The G3215A Mass Spec Bench does not support the MS 120 rough pump that is used with the 6495C LC/TQ. For use with the 6495C/MS 120 rough pump,  order the G3215A #001 Mass Spec Table.<div class="imageContainer imageContainer_100 " style="padding-top: 20px; float:none"><img src="images/topic04/bench_requirement.jpg"></img></div></div></div>' ,
											details:{									
											1:{
											text: "Bench requirement , Supporting benches for the 6400 Series LC/TQ system are available from Agilent. Contact your Agilent representatives for ordering information on the appropriate bench for your lab. , The G3215A Mass Spec Bench does not support the MS 120 rough pump that is used with the 6495C LC/TQ.,For use with the 6495C/MS 120 rough pump,  order the G3215A #001 Mas Spec Table."
											},								 
											}
											}, // page
											
											{  
											title: "Space and weight requirements" ,
											short_title: "Space and weight requirements" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'><span class='caution'>CAUTION</span> Do not put the rough pump on your laboratory bench with the LC/MS due to the vibration that the pump creates. This can lead to a loss of mass accuracy and resolution.<p> The bench space must be large enough and strong enough to support the LC/MS and LC system, data system, and accessories. The surface must be relatively free of vibration.​<br><br>Please refer to the Site Preparation Checklist, under <b>Dimensions and Weight</b>, for the LC/MS, source, and foreline pump dimensions and weight.​<br><br>You must leave at least 30 cm (12 inches) to the left of the source and the fan to provide adequate access and ventilation.</p> </div></div>" ,/*<div class="tableBorder"></div> */
											details:{									
											1:{
											text: " The bench space must be large enough and strong enough to support the LC/MS and LC system, data system, and accessories. The surface must be relatively free of vibration. , Please refer to the Site Preparation Checklist, under Dimensions and Weight, for the LC/MS, source, and foreline pump dimensions and weight., You must leave at least 30 cm (12 inches) to the left of the source and the fan to provide adequate access and ventilation.,  "
											},								 
											}
											}, // page
											//6470
											{  
											title: "Space and weight requirements - non-iFunnel LC/TQ" ,
											short_title: "blank",
											type: "video" ,
											path : "video/topic03/space_and_weight_6470.mp4" ,
											PdfPath : "pdf/topic04/space_and_weight_6470.pdf",
										
											details: {
											1:{ cuePoint : 0,
												tag:"Adequate space",
												text: "Adequate space is available for the non-iFunnel LC/TQ."
											  },
										
											2:{ cuePoint :5,
												tag:"Suitable supporting bench",
												text: "A suitable supporting bench is available.<br>The supporting surface must be sturdy enough to support the weight of the entire LC/TQ system and any accessories."
											  },
											  
											3:{ cuePoint :11,
												tag:"blank",
												text: " "
											  },
										  
											4:{ cuePoint : 16,
												tag:"Dimensions of non-iFunnel LC/TQ",
												text: "Total height of non-iFunnel LC/TQ is 47.5 cm (18.7 inches)"
											  },
										
											5:{ cuePoint : 21,
												tag:"blank",
												text: "Total height of non-iFunnel LC/TQ is 47.5 cm (18.7 inches) <br>Total width of non-iFunnel LC/TQ is 77.3 cm (30.4 inches)"
											  },
											  
											6:{ cuePoint : 27,
												tag:"blank",
												text: " "
											  },
											  
											7:{ cuePoint : 29,
												tag:"blank",
												text: "Total depth of non-iFunnel LC/TQ is 84 cm (33 inches)"
											  },
											  
											8:{ cuePoint : 35,
												tag:"blank",
												text: " "
											  },
											  
											9:{ cuePoint : 38,
												tag:"blank",
												text: "There must be sufficient space around the instrumentation for air flow and maintenance access.<br> At least 15 cm (approximately 6 inches) space should be maintained behind the non-iFunnel LC/TQ."
											  },
											  
											10:{ cuePoint : 44,
												tag:"blank",
												text: " "
											  },
											  
											11:{ cuePoint : 45,
												tag:"blank",
												text: "At least 30 cm (12 inches) of space to the left and 8 cm (3 inches) of space to the right of the instrument should be maintained for proper ventilation. And no other devices (e.g. a nitrogen generator) should exhaust into this side of the instrument."
											  },
											  
											12:{ cuePoint : 53,
												tag:"blank",
												text: " "
											  },
											  
											13:{ cuePoint : 55,
												tag:"Dimensions of foreline pump and drain bottle",
												text: "The foreline pump(s) must be located under the laboratory bench or on the floor. A 200 cm (79 inches) vacuum hose must be able to connect between the foreline pump and LC/TQ."
											  },
											  
											14:{ cuePoint : 61,
												tag:"blank",
												text: " "
											  },
											  
											15:{ cuePoint : 62,
												tag:"blank",
												text: "Waste bottle must be positioned below the non-iFunnel LC/TQ instrument. The drain bottle is supplied with a 180 cm (72 inches) PTFE hose."
											  },
											  
											16:{ cuePoint : 68,
												tag:"blank",
												text: " "
											  },
											}
											}, // page
											//6495
											{  
												title: "Space and weight requirements - iFunnel LC/TQ" ,
												short_title: "blank",
												type: "video" ,
												path : "video/topic03/6495/space_and_weight_6495.mp4" ,
												PdfPath : "pdf/topic04/6495/space_and_weight_6495.pdf",
											
												details: {
												1:{ cuePoint : 0,
													tag:"Adequate space",
													text: "Adequate space is available for the iFunnel LC/TQ."
												  },
											
												2:{ cuePoint :5,
													tag:"Suitable supporting bench",
													text: "A suitable supporting bench is available.<br>The supporting surface must be sturdy enough to support the weight of the entire LC/TQ system and any accessories."
												  },
												  
												3:{ cuePoint :11,
													tag:"blank",
													text: " "
												  },
											  
												4:{ cuePoint : 16,
													tag:"Dimensions of iFunnel LC/TQ",
													text: "Total height of iFunnel LC/TQ is 47.5 cm (18.7 inches)"
												  },
											
												5:{ cuePoint : 21,
													tag:"blank",
													text: "Total height of iFunnel LC/TQ is 47.5 cm (18.7 inches) <br>Total width of iFunnel LC/TQ is 77.3 cm (30.4 inches)"
												  },
												  
												6:{ cuePoint : 27,
													tag:"blank",
													text: " "
												  },
												  
												7:{ cuePoint : 29,
													tag:"blank",
													text: "Total depth of iFunnel LC/TQ is 91.5 cm (36 inches)"
												  },
												  
												8:{ cuePoint : 35,
													tag:"blank",
													text: " "
												  },
												  
												9:{ cuePoint : 38,
													tag:"blank",
													text: "There must be sufficient space around the instrumentation for air flow and maintenance access.<br> At least 15 cm (approximately 6 inches) space should be maintained behind the iFunnel LC/TQ system."
												  },
												  
												10:{ cuePoint : 44,
													tag:"blank",
													text: " "
												  },
												  
												11:{ cuePoint : 45,
													tag:"blank",
													text: "At least 30 cm (12 inches) of space to the left and 8 cm (3 inches) of space to the right of the instrument should be maintained for proper ventilation. And no other devices (e.g. a nitrogen generator) should exhaust into this side of the instrument."
												  },
												  
												12:{ cuePoint : 53,
													tag:"blank",
													text: " "
												  },
												  
												13:{ cuePoint : 55,
													tag:"Dimensions of foreline pump and drain bottle",
													text: "The foreline pump(s) must be located under the laboratory bench or on the floor. A 200 cm (79 inches) vacuum hose must be able to connect between the foreline pump and LC/TQ."
												  },
												  
												14:{ cuePoint : 61,
													tag:"blank",
													text: " "
												  },
												  
												15:{ cuePoint : 62,
													tag:"blank",
													text: "Waste bottle must be positioned below the iFunnel LC/TQ. The drain bottle is supplied with a 180 cm (72 inches) PTFE hose."
												  },
												  
												16:{ cuePoint : 68,
													tag:"blank",
													text: " "
												  },
												}
												}, // page
	


											{  
											title: "Space and weight requirements" ,
											short_title: "blank" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'><div class='imageContainer imageContainer_100'><img src='images/topic04/suggested_config.jpg'></img></div></div></div>" ,
											details:{									
											1:{
											text: "Space and weight requirements"
											},								 
											}
											}, // page
											
								 
											{  
											title: "Operating environment" ,
											short_title: "Operating environment" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'><h4>Environmental Conditions</h4>The LC/TQ is designed for use in the following environmental conditions for Class 1 Laboratory equipment, as specified by the International <br>Electro-technical Commission (IEC).<table style='margin-top:10px;'><tr><td>Equipment class</td><td>Class 1 Laboratory equipment</td></tr><tr><td>Pollution</td><td>Degree 2</td></tr><tr><td>Installation</td><td>Category II</td></tr><tr><td>Environment</td><td>Indoor use</td></tr><tr><td>Altitude</td><td>Not to exceed 3,000 m (10,000 ft)</td></tr><tr><td>Electrical supply</td><td>See the Site Preparation Checklist for specific information for your model.</td></tr><tr><td rowspan='2' style='padding-bottom:45px'>Mains supply voltage</td><td>For ESI: Fluctuations not to exceed 10% of nominal supply voltage.</td></tr><tr><td>For AJS: Fluctuations not to exceed +10/-5% from the rated voltage.</td></tr><td>Operating temperature</td><td>15 to 35 °C (59 to 95 °F)</td></tr><tr><td>Humidity</td><td>< 85% RH at 35 °C</td></tr></table>" ,
											details:{									
											1:{
											text: " Operating environment , Environmental Conditions , The LC/TQ is designed for use in the following environmental conditions for Class 1 Laboratory equipment, as specified by the International Electro-technical Commission (IEC). , Equipment class , Class 1 Laboratory equipment , Pollution , Degree 2 , Installation , Category II , Environment , Indoor use , Altitude , Not to exceed 3,000 m (10,000 ft) , Electrical supply , See the Site Preparation Checklist for specific information for your model. , Mains supply voltage , Fluctuations not to exceed 10% of nominal supply voltage , Operating temperature , 15 to 35 °C (59 to 95 °F) , Humidity , < 85% RH at 35 °C ,Mains supply voltage, For ESI: Fluctuations not to exceed 10% of nominal supply voltage., For AJS: Fluctuations not to exceed +10/-5% from the rated voltage."
											},								 
											}
											}, // page
											
											{  
											title: "Operating environment" ,
											short_title: "blank" ,
											type: "video" ,
											path : "video/topic03/Operating_Environment.mp4" ,
											PdfPath : "pdf/topic04/Operating_Environment.pdf",
											details: 
													{
														
													1:{ cuePoint : 2,
													tag:"Altitude",
													text: "Altitude: Not to exceed 3,000 m",
													},
													
													2:{ cuePoint : 6,
													tag:"Electrical supply",
													text: "Electrical supply: Refer to the Site Preparation Checklist for exact specifications.<br>Mains supply voltage fluctuation: ​<br>For ESI, not to exceed 10% of nominal supply voltage.​ <br>For AJS, not to exceed +10/-5% from the rated voltage."
													},
													
													3:{ cuePoint :11,
													tag:"Operating temperature",
													text: "Operating Temperature: 15 to 35 &#176;C (59 to 95 &#176;F) "
													},
													
													4:{ cuePoint :15,
													tag:"Humidity",
													text: "Humidity: 20-85% RH at 35 &#176;C"
													},
													
												}
											},
											
											{  
												title: "Telephone" ,
												short_title: "Telephone" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div style='float:left;margin-right:10px;'><img src='images/topic01/Telephone.jpg'></div><div class='textContainer textContainer_80'>Agilent recommends that a telephone or cell phone service is available within reach of the computer. The Agilent Technologies field personnel may need to communicate with an Agilent support personnel.</div></div>" ,
												details:{									
												1:{
												text: "Telephone , Agilent recommends that a telephone or cell phone service is available within reach of the computer. The Agilent Technologies field personnel may need to communicate with an Agilent support personnel."
												},								 
												}
											}, // page
											
											{  
												title: "LAN network" ,
												short_title: "LAN network" ,
												type: "text_image" ,
												content : "<div class='imageContainer imageContainer_100' style='float:left'><img src='images/topic04/LAN_6470.png'></img></div>" ,
												details:{									
												1:{
												text: "LAN network"
												},								 
												}
											}, // page
											
											{  
												title: "Site LAN network" ,
												short_title: "blank" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'>If you intend to connect the control PC to your site's LAN network, you need an additional network cable. Internet access for the control PC is strongly recommended to allow remote control and diagnosis of the LC/MS through remote access software. This is required for some service contracts.<br><br><span class='note'>NOTE</span>Agilent Technologies is not responsible for connecting to or establishing communication with your site LAN network. The service representative will test the ability of the Agilent instruments to communicate with the control PC only.<br><br><span class='note'>NOTE</span>The LC/MS has a fixed IP address. It can only connect to a control PC and not to the site network.</div></div>" ,
												details:{									
												1:{
												text: "Site LAN network ,If you intend to connect the control PC to your site's LAN network, you need an additional network cable. Internet access for the control PC is strongly recommended to allow remote control and diagnosis of the LC/MS through remote access software. This is required for some service contracts., Agilent Technologies is not responsible for connecting to or establishing communication with your site LAN network. The service representative will test the ability of the Agilent instruments to communicate with the control PC only., The LC/MS has a fixed IP address. It can only connect to a control PC and not to the site network."
												},								 
												}
											}, // page
											
								
							
										]  //pageList
						},//subChapter		
				}//subChapterList			
		}, // chapter 
		
		4:{ 			
				chapterName : "Air conditioning requirements",
				iconPath : "images/submenuicon/LCTQ/Air_Conditioning_Requirements.png",
				subChapterList : {
					1:{ 
							subChapterName : "Air conditioning requirements",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [
											{  
											title: "Temperature and humidity" ,
											short_title: "Temperature and humidity" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'>The 6400 Series LC/TQ is specified for operation under the following conditions:<ul><li>15 to 35 °C (59 to 95 °F)</li><li>Constant temperature (< +/-3 °C from calibration temperature)</li><li>< 85% relative humidity at 35 °C</li><li>Non-condensing, non-corrosive atmosphere</li></ul><p>Environmental control systems must maintain these temperatures and humidity ranges.</p><p>The LC/MS, source, and rough pump dissipate a large amount of heat. For your system specifications, refer to the Site Preparation Checklist.​<br>The LC and data system also contribute significantly to the cooling load. The exact amounts depend on their configurations.</p><p>Additional allowances should be made for other heat sources such as heat from other equipment, heat from adjacent rooms, and heat from laboratory personnel.</p></div></div>" ,
											details:{									
											1:{
											text: "Temperature and humidity , The 6400 Series LC/TQ is specified for operation under the following conditions: , 15 to 35 °C (59 to 95 °F) , Constant temperature (< +/-3 °C from calibration temperature) , < 85% relative humidity at 35 °C , Non-condensing, non-corrosive atmosphere , Environmental control systems must maintain these temperatures and humidity ranges., The LC/MS, source, and rough pump dissipate a large amount of heat. For your system specifications, refer to the Site Preparation Checklist.​ The LC and data system also contribute significantly to the cooling load. The exact amounts depend on their configurations.,Additional allowances should be made for other heat sources such as heat from other equipment, heat from adjacent rooms, and heat from laboratory personnel."
											},								 
											}
											}, // page
											
											//for 6470
											{  
											title: "Temperature and humidity" ,
											short_title: "blank" ,
											type: "video" ,
											path : "video/topic03/temperature_n_humidity_6470.mp4" ,
											PdfPath : "pdf/topic04/temperature_n_humidity_6470.pdf",
										
											details: {
											1:{ cuePoint : 0,
												tag:"The 6400 Series LC/TQ dissipates heat from the chassis and source",
													text: "The 6400 Series LC/TQ dissipates heat from the chassis and source. Check the Site Preparation Checklist for rate of dissipation. "
											  },
											  
											2:{
												cuePoint : 14,
												tag:"The foreline pump dissipates heat",
												text: "The foreline pump dissipates heat. "
											  },

											3:{ cuePoint : 20,
												tag:"The LC and data system also contribute significantly",
												text: "The LC and data system also contribute significantly. The exact amounts depend on their configurations. "
											  },
											}
											}, // page
											 

											{  
											title: "Airborne dust" ,
											short_title: "Airborne dust" ,
											type: "video" ,
											path : "video/topic03/Airborne_Dust.mp4" ,
											PdfPath : "pdf/topic04/Airborne_Dust.pdf",
										
											details: {
											1:{ cuePoint : 0,
												tag:"Lab with airborne dust",
												text: "Agilent recommends a maximum airborne particle density of 55 mg/m<sup>3</sup>. If you suspect your site exceeds this limit, contact your local Agilent Customer Service Organization. They can offer suggestions for reducing airborne dust."
											  },
										
											2:{ cuePoint : 9,
												tag:"blank",
												text: " "
											  },
											  
											  
											}
											}, // page
											
											{  
											title: "Exhaust venting" ,
											short_title: "Exhaust venting" ,
											type: "video" ,
											path : "video/topic03/Exhaust_Venting.mp4" ,
											PdfPath : "pdf/topic04/Exhaust_Venting.pdf",
										
											details: {
											1:{ cuePoint : 0,
												tag:"Exhaust sources of the 6400 Series LC/TQ",
												text: "Two sources of exhaust on the 6400 Series LC/TQ: the Spray Chamber and the Foreline Pump."
											  },
											  
											2:{ cuePoint : 8,
												tag:"blank",
												text: " ",
											  },
										
											3:{ cuePoint : 9,
												tag:"blank",
												text: "There are two sources of exhaust vent on the agilent LC/TQ the spray chamber and foreline pump. The drain hose routes both nitrogen gas and vapor from the spray chamber to drain bottle. The vapor is made up of mobile phase and sample. The spray chamber and foreline pump vent up to 30 liters/minute of nitrogen gas and vapor. "
											  },
											  
											4:{ cuePoint : 16,
												tag:"blank",
												text: "Do not use a same hose for venting because the foreline pump exhaust contains traces of solvent, sample, and hydrocarbon pump fluid. The mist filter on the foreline pump traps the majority of the pump fluid vapor. It does not trap the traces of solvent and sample that may be present in the exhaust gases."
											  },
											  
											5:{ cuePoint : 27,
												tag:"blank",
												text: "Air needs to flow away from the instrument."
											  },
											  
											  
											6:{ cuePoint : 40,
												tag:"The spray chamber exhaust and the foreline pump exhaust are vented externally",
												text: "The spray chamber exhaust and the foreline pump exhaust are vented externally to the building and not recirculated by the environmental control system."
											  },
											
											7:{ cuePoint : 54,
												tag:"blank",
												text: " "
											  },
											}
											}, // page
											
											{  
											title: "Exhaust venting" ,
											short_title: "blank" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'><span class='warning'>WARNING</span>Failure to vent the rough pump and spray chamber separately will void the warranty for the LC/MS. Agilent service representatives will not install an Agilent LC/TQ until an adequate exhaust system is present and functioning. <br><br><span class='caution'>CAUTION</span>The spray chamber exhaust and rough pump exhaust must be vented using separate lengths of exhaust tubing. These may be connected into a common exhaust manifold. This is to minimize the chances of rough pump fluid vapor entering the spray chamber when drying gas is not flowing. If connecting to a common exhaust manifold, the source should be plumbed in upstream of where the rough pump exhaust is plumbed into the manifold.<br><br><span class='caution'>CAUTION</span>Your exhaust venting system must be able to handle the combined exhaust flow from the spray chamber and the rough pump. Refer the Site Preparation Checklist for the specifications for your system.<br><br><span class='caution'>CAUTION</span>Flow is continuous as long as the instrument is on. Both exhaust vents must be at or slightly below atmospheric pressure <br>(negative pressure). If a negative pressure vent is not available, the length of the tubing from the rough pump and the drain bottle to the vent should each not exceed 460 cm (180 inches).<br><br><span class='caution'>CAUTION</span>Positive pressure in the spray chamber exhaust tubing and drain bottle can affect instrument performance and may contribute to excessive background contaminant levels.</div></div>" ,
											details:{									
											1:{
											text: " WARNING , Failure to vent the rough pump and spray chamber separately will void the warranty for the 6400 Series LC/TQ. Agilent service representatives will not install an Agilent 6400 Series LC/TQ until an adequate exhaust system is present and functioning.  , CAUTION , The spray chamber exhaust and rough pump exhaust must be vented using separate lengths of exhaust tubing. These may be connected into a common exhaust manifold. This is to minimize the chances of rough pump fluid vapor entering the spray chamber when drying gas is not flowing. If connecting to a common exhaust manifold, the source should be plumbed in upstream of where the rough pump exhaust is plumbed into the manifold. ,Your exhaust venting system must be able to handle the combined exhaust flow from the spray chamber and the rough pump. Refer the Site Preparation Checklist for the specifications for your system., Flow is continuous as long as the instrument is on. Both exhaust vents must be at or slightly below atmospheric pressure (negative pressure)If a negative pressure vent is not available, the length of the tubing from the rough pump and the drain bottle to the vent should each not exceed 460 cm (180 inches). , Positive pressure in the spray chamber exhaust tubing and drain bottle can affect instrument performance and may contribute to excessive background contaminant levels. "
											},								 
											}
											}, // page
										]  //pageList
						},//subChapter

							
				}//subChapterList			
		}, // chapter 
		
		5:{ 			
				chapterName : "Electrical requirements",
				iconPath : "images/submenuicon/LCTQ/Electrical_Requirements.png",
				subChapterList : {
					1:{ 
							subChapterName : "Electrical requirements",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [  
											{  
												title: "Voltage and power requirements" ,
												short_title: "Voltage and power requirements" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'>The customer is responsible for providing appropriate electrical power and power outlets for all components and accessories used with the LC/MS system. Power considerations include: <ul><li>Voltage ranges of major components</li><li>Power requirements of major component	</li><li>Single-phase power configurations</li><li>Power plugs, receptacles and cords</li></ul><p>The LC/MS system includes a wide-range power supply that can operate without reconfiguration.</p><p><span class='note'>NOTE</span> The LC/MS, LC, and data system each requires a separate branch circuit breaker.</p><p>Refer to the Site Preparation Checklist for details on exact voltage and power requirements for your instrument and pump. </P><div style='display: inline-block;'><div style='float:left;text-align: center;padding: 20px;border:1px solid #b3b3b3;margin-right:15px;'><img src='images/topic01/power_51.jpg'></div><div style='margin-bottom:20px;'><span class='caution'>CAUTION</span>If an instrument is being ordered from one location, but is to be installed in another location with different electrical power characteristics, a special note must be made on the order that the electrical power at the site is different from the standard electrical power in that country.</div></div><p>Power must meet the stated stability specifications. Use a line monitor to check the power stability. If the line power is unstable, it may be necessary to install a line conditioner.</p></div></div>",
												details:{									
												1:{
												text: "Voltage and Power requirements , The customer is responsible for providing appropriate electrical power and power outlets for all components and accessories used with the LC/MS system., Power considerations include: ,Voltage ranges of major components, Power requirements of major component	, Single-phase power configurations, Power plugs, receptacles and cords, The LC/MS system includes a wide-range power supply that can operate without reconfiguration., Note that the LC/MS, LC, and data system each requires a separate branch circuit breaker., Refer to the Site Preparation Checklist for details on exact voltage and power requirements for your instrument and pump., CAUTION , If an instrument is being ordered from one location, but is to be installed in another location with different electrical power characteristics, a special note must be made on the order that the electrical power at the site is different from the standard electrical power in that country. , Power must meet the stated stability specifications. Use a line monitor to check the power stability. If the line power is unstable, it may be necessary to install a line conditioner."
												},								 
												}
											}, // page
											
											 
											
											{  
											title: "Voltage and power requirements" ,
											short_title: "blank" ,
											type: "video" ,
											path : "video/topic03/voltage_range_n_power_requirement.mp4" ,
											PdfPath : "pdf/topic04/voltage_range_n_power_requirement.pdf",
										
											details: {
												1:{ cuePoint : 0,
													tag:"Relocate the radio or antenna",
													text: "Relocate the radio or antenna.<br>Move the device away from the radio or television."
												  },
											
												2:{ cuePoint : 9,
													tag:"Plug the device into a different electrical outlet",
													text: "Plug the device into a different electrical outlet, so that each device is on separate electrical circuits."
												  },
												  
												3:{ cuePoint : 28,
													tag:"blank",
													text: " "
												  }, 
												
												}
											}, // page
											
											{  
												title: "Power configurations" ,
												short_title: "Power configurations" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>Electrical power for the Agilent LC/MS may be delivered in either single-phase or 208 Wye configuration.<p>Refer to the Site Preparation Checklist forthe primary voltage characteristics of each configuration. Correct grounding for the 208-Wye configuration must be verified by an electrician. The neutral wire cannot be used for safety grounding.</p><div style='display:inline-block;margin-bottom: 20px;'><div style='float:left;text-align: center;padding: 20px;border:1px solid #b3b3b3;margin-right:15px;'><img src='images/topic01/power_config.png'></div><div style='margin-bottom:20px;'>The ground wire should carry zero current except for ground-fault current or static electric discharge. The entire system should share an isolated, noise-free electrical ground that is connected to the main earth ground for the facility.</div></div><br><span class='warning'>WARNING</span>The power source to which you connect an Agilent LC/MS must be equipped with a protective earth contact (ground).<br><br><span class='warning'>WARNING</span>Do not interrupt the protective earth contact inside or outside the LC/MS or disconnect the protective earth terminal (ground). </div></div>" ,
												details:{									
												1:{
												text: "Power configurations , Electrical power for the Agilent LC/MS may be delivered in either single-phase or 208 Wye configuration. , Refer to the Site Preparation Checklist forthe primary voltage characteristics of each configuration. Correct grounding for the 208-Wye configuration must be verified by an electrician. The neutral wire cannot be used for safety grounding. , The ground wire should carry zero current except for ground-fault current or static electric discharge. The entire system should share an isolated, noise-free electrical ground that is connected to the main earth ground for the facility. , WARNING , The power source to which you connect an Agilent LC/MS must be equipped with a protective earth contact (ground). , Do not interrupt the protective earth contact inside or outside the LC/MS or disconnect the protective earth terminal (ground). ,  "
												},								 
												}
											}, // page
											
											{  
												title: "Power plugs and cords" ,
												short_title: "Power plugs and cords" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>The LC/MS is supplied with an appropriate power cord and plug for the country in which the order originates. The length of all LC/MS power cords is approximately 2.4 m (94 inches).<p>The data system components also include power cords with plugs appropriate for the country in which the order was placed. Power cord lengths for the data system components and accessories are approximately 2.3 m (90 inches).</p><p>“Power cords” in the Reference section shows the style of the plug for the cord that will ship to your country. Make sure that the power receptacles in your laboratory can accommodate this configuration. If needed, consult with your Agilent representative.</p><span class='caution'>CAUTION</span>If an instrument is being ordered from one location, but is to be installed in another location with different electrical power characteristics, advise your Agilent sales representative to make a note on your order of the electrical power characteristics for the location where the instrument will be installed.<br> <br> <div style='width:100%'><div style='width:90%;float:left'><span class='warning'>WARNING</span>Do not use extension cords with the LC/MS. Extension cords cannot provide enough power and can be a safety hazard.</div><div style='float:left;text-align: center;padding: 15px;border:1px solid #b3b3b3'><img src='images/topic01/extension_cord.jpg'></div></div></div></div>" ,
												details:{									
												1:{
												text: "Power plugs and cords , The LC/MS is supplied with an appropriate power cord and plug for the country in which the order originates. The length of all LC/MS power cords is approximately 2.4 m (94 inches). , The data system components also include power cords with plugs appropriate for the country in which the order was placed. Power cord lengths for the data system components and accessories are approximately 2.3 m (90 inches). , CAUTION , If an instrument is being ordered from one location, but is to be installed in another location with different electrical power characteristics, advise your Agilent sales representative to make a note on your order of the electrical power characteristics for the location where the instrument will be installed. , WARNING ,Do not use extension cords with the LC/MS. Extension cords cannot provide enough power and can be a safety hazard."
												},								 
												}
											}, // page
											
											{  
												title: "Other electrical considerations" ,
												short_title: "Other electrical considerations" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>Additional electrical considerations include:<ul><li>Electromagnetic interference (EMI), such as is generated by NMRs, radio transmitters, and microwave links, may interfere with system performance.</li><li>Protect the system from static electricity by observing humidity and temperature requirements. Minimize the presence of non-conductive products such as carpets and vinyl floor tiles.</li><li>Install emergency-off pushbuttons that can disconnect power to all electric equipment in the room except overhead lighting and ventilation system.</li><li>Separate convenience outlets should be provided for building maintenance and other appliances. Convenience outlets must be on circuits separate from the 6400 Series LC/TQ system. Convenience outlets must share the normal building distribution ground, not the 6400 Series LC/TQ system ground.</li><li>In areas where frequent power outages are experienced, Agilent recommends to install an uninterruptable power supply.​</li></ul></div></div>" ,
												details:{									
												1:{
												text: "Other electrical considerations , Additional electrical considerations include: , Electromagnetic interference (EMI), such as is generated by NMRs, radio transmitters, and microwave links, may interfere with system performance. , Protect the system from static electricity by observing humidity and temperature requirements. Minimize the presence of non-conductive products such as carpets and vinyl floor tiles. , Install emergency-off pushbuttons that can disconnect power to all electric equipment in the room except overhead lighting and ventilation system. , Separate convenience outlets should be provided for building maintenance and other appliances. Convenience outlets must be on circuits separate from the 6400 Series LC/TQ system. Convenience outlets must share the normal building distribution ground, not the 6400 Series LC/TQ system ground. , In areas where frequent power outages are experienced, Agilent recommends to install an uninterruptable power supply.​"
												},								 
												}
											}, // page
										]  //pageList
					},//subChapter
					
			},//subChapterList
		},//Chapter
			
		6:{ 			
				chapterName : "Gas requirements",
				iconPath : "images/submenuicon/LCTQ/Gas_Requirements.png",
				subChapterList : {
					1:{ 
							subChapterName : "Gas requirements",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [  
											{  
												title: "Nitrogen gas requirements" ,
												short_title: "Nitrogen gas requirements" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>The Agilent LC/MS requires large quantities of high-purity nitrogen for drying gas, nebulizing gas, sheath gas (for AJS source), collision cell gas, and to pressurize the calibrant delivery system.<p><span class='warning'>WARNING</span>Use only nitrogen for the drying and nebulizing gas. Use of air, oxygen, or other gases when combined with volatile solvents and high voltages in the spray chamber, could result in an explosion. Use of air, oxygen, or other gases may also cause deterioration of parts in the 6400 Series LC/TQ and have a negative effect on instrument operation and sensitivity.</p><p>Due to the large volumes of nitrogen required for instrument operation, the use of a nitrogen generator (gas separator) or a large (160 liters or greater) dewar of liquid nitrogen is required. High pressure nitrogen bottles are not suitable for drying gas supply with the LC/TQ except for use as the collision cell gas supply.</p><p>Agilent Technologies offers several nitrogen gas generators well suited for use with the LC/MS. Check with your Agilent representative to purchase one of these generators.</p><span class='warning'>WARNING</span>Contact your gas supplier for handling and safety information for the gases you use. Compressed or liquefied gases can be dangerous.</div></div>" ,
												details:{									
												1:{
												text: "Nitrogen gas requirements , The Agilent LC/MSrequires large quantities of high-purity nitrogen for drying gas, nebulizing gas, sheath gas (for AJS source), collision cell gas, 	and to pressurize the calibrant delivery system. , WARNING , Use only nitrogen for the drying and nebulizing gas. Use of air, oxygen, or other gases when combined with volatile solvents and high voltages in the spray chamber, could result in an explosion. Use of air, oxygen, or other gases may also cause deterioration of parts in the 6400 Series LC/TQ and have a negative effect on instrument operation and sensitivity. , Due to the large volumes of nitrogen required for instrument operation, the use of a nitrogen generator (gas separator) or a large (160 liters or greater) dewar of liquid nitrogen is required. High pressure nitrogen bottles are not suitable for drying gas supply with the LC/TQ except for use as the collision cell gas supply. , Agilent Technologies offers several nitrogen gas generators well suited for use with the LC/MS. Check with your Agilent representative to purchase one of these generators. , Contact your gas supplier for handling and safety information for the gases you use. Compressed or liquefied gases can be dangerous. "
												},								 
												}
											}, // page
											
											// {  
											// 	title: "Nitrogen gas requirements - 6470 Series" ,
											// 	short_title: "blank" ,
											// 	type: "text_image" ,
											// 	content: '<div class="imageContainer imageContainer_100" style="float:left"><img src="images/topic04/Nitrogen_6470.png"></img></div>' ,
											// 	details:{									
											// 	1:{
											// 	text: "Nitrogen gas requirements"
											// 	},								 
											// 	}
											// }, // pag
											// {  
											// 	title: "Nitrogen gas requirements - 6495 Series" ,
											// 	short_title: "blank" ,
											// 	type: "text_image" ,
											// 	content: '<div class="imageContainer imageContainer_100" style="float:left"><img src="images/topic04/Nitrogen_6495.png"></img></div>' ,
											// 	details:{									
											// 	1:{
											// 	text: "Nitrogen gas requirements"
											// 	},								 
											// 	}
											// }, // pag
											
											{  
												title: "Nitrogen purity" ,
												short_title: "Nitrogen purity" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>The nitrogen gas used for drying gas must be free of contaminants.  Nitrogen generators and nitrogen dewars are commonly used as the primary nitrogen source because they are the best to mitigate common contaminants that interfere with LC/MS. Nitrogen generators offer the advantages of less frequent maintenance and source gas filtration but are limited in their purity. Dewars generally offer a higher purity but do not inherently filter the source gas. Dewars also have a finite volume, which results in more frequent maintenance. <div style='width:102px;text-align:center;float:left;margin-right:10px;margin-bottom:10px;border:1px solid #b3b3b3;'><img src='images/topic02/Nitrogen_purity.jpg'></div><p style='padding-top:20px;'>One or more high-capacity gas conditioner is supplied with the Agilent LC/MS. Its primary function is to remove hydrocarbon contamination from the nitrogen before it reaches the LC/MS. Refer to the Site Preparation Checklist for nitrogen flow requirements for your system. This conditioner has 1/4-inch Swagelok fittings.</p><br><br><p><span class='note'>NOTE</span>Use of high-pressure nitrogen bottles is not supported due the high usage rate.​<p> <table><tr><th class='txt_center'>Source</th><th class='txt_center' width='400px'>Purity</th><th class='txt_center'>Gas Pressure</th> </tr>  <tr> <td>Liquid nitrogen dewar or Nitrogen generator</td><td>>95.0% and hydrocarbon-free (less than 1 ppm, with the remaining gas being oxygen and trace argon)</td><td rowspan='2'>5.5 to 6.8 bar<br>(80 to 100 PSI)<br>(550 to 690 kPa)​</td> </tr> </table></div></div>" ,
												details:{									
												1:{
												text: "Nitrogen purity , The nitrogen gas used for drying gas must be free of contaminants. Purity specifications vary according to the source of the nitrogen. This is due to the different types of contaminants common to different nitrogen sources. , When using a nitrogen generator, oxygen is the primary contaminant of the gas supply. Oxygen has less impact on LC/MS sensitivity, and in some operating modes and certain applications may enhance sensitivity in small concentrations. Therefore, the purity specification for gas from a nitrogen generator can be less stringent. , A high-capacity gas conditioner is supplied with the Agilent LC/MS. Its primary function is to remove hydrocarbon contamination from the nitrogen before it reaches the LC/MS. This conditioner has 1/4-inch Swagelok fittings. , NOTE , Use of high pressure nitrogen bottles is not supported due the high usage rate., Model , Source , Purity , Gas Pressure , Flow , 6470 , Liquid nitrogen dewar , 99.5% pure 1 or better and hydrocarbon-free , 5.5 to 6.8 bar (80 to 100 PSI) (550 to 690 kPa)​,  Nitrogen generator , 95.0% pure or better and hydrocarbon-free 2 , 6495 , Liquid nitrogen dewar , 99.5% pure 1 or better and hydrocarbon-free , 5.5 to 6.8 bar (80 to 100 PSI) (550 to 690 kPa)​ ,  Nitrogen generator , 95.0% pure or better and hydrocarbon-free 2 , 1 Bottled nitrogen tends to be contaminated with hydrocarbons, which can severely degrade LC/MS sensitivity. Even with the gas conditioner (purifier) supplied with the LC/MS, it is virtually impossible to remove all hydrocarbon contaminants if the bottled nitrogen does not start with at least 99.5% purity. Remaining impurities can be oxygen only. 2 Less than 0.1 parts per million hydrocarbons with the remaining gas being oxygen and trace argon. , 3 At least 3 liters/minute is required at all times to prevent air from entering the LC/MS. , 4 At least 9 liters/minute is required at all times to prevent air from entering the LC/TQ. "
												},								 
												}
											}, // page
											{  
												title: "Collision cell reagent gas purity" ,
												short_title: "Collision cell reagent gas purity" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>The collision cell gas must be a higher purity than the gas used as drying gas. You can use high-pressure bottled nitrogen as the collision cell reagent gas.​<p>A high-capacity gas conditioner for collision cell reagent gas is supplied with the LC/MS. Its primary function is to remove hydrocarbon contamination from the nitrogen before it reaches the collision cell. This conditioner has 1/4-inch Swagelok fittings.​</p><p>The supplied conditioner is to be used with nitrogen only.​</p><p>Agilent does not support the use of a separate regulator to split the drying gas flow, due to the uncertainty in the purity of the drying gas source.</p><table><tr><th class='txt_center'>Source</th><th style='width: 300px;' class='txt_center'>Purity</th><th class='txt_center'>Gas Pressure</th><th class='txt_center'>Flow</th></tr><tr valign='top'> <td>High-pressure bottled nitrogen</td><td>>99.998% and hydrocarbon-free <br>(less than 1 ppm)</td><td> 5.5 to 6.8 bar <br>(80 to 100 PSI)<br>(550 to 690 kPa)​</td><td>Up to 1 mL/minute</td></tr></table></div></div>" ,
												details:{									
												1:{
												text: "Collision cell reagent gas purity ,The collision cell gas must be a higher purity than the gas used as drying gas. You can use high-pressure bottled nitrogen as the collision cell reagent gas.​, A high-capacity gas conditioner for collision cell reagent gas is supplied with the LC/MS. Its primary function is to remove hydrocarbon contamination from the nitrogen before it reaches the collision cell. This conditioner has 1/4-inch Swagelok fittings.​, The supplied conditioner is to be used with nitrogen only., Agilent does not support the use of a separate regulator to split the drying gas flow, due to the uncertainty in the purity of the drying gas source.,Source,	Purity,	Gas Pressure,	Flow,High-pressure bottled nitrogen,>99.998% and hydrocarbon-free (less than 1 ppm),5.5 to 6.8 bar (80 to 100 PSI),(550 to 690 kPa)​	Up to 1 mL/minute"
												},								 
												}
												}, // page
											{  
												title: "Nitrogen regulators, tubing, and fittings" ,
												short_title: "Nitrogen regulators, tubing, and fittings" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div style='float:left;margin:0 15px 0 15px'><img src='images/topic01/Regulator.jpg'></div><div class='textContainer' style='width:72%'>You must supply appropriate regulators for your sources of nitrogen gas. The regulators must be able to supply gas in the specified pressure ranges.<p>The regulator for the drying gas must have one outlet with 1/4- inch Swagelok fittings. Gas generators have built-in regulators so they do not require an external regulator. A dewar of liquid nitrogen typically requires a regulator (see the dewar manufacturer's literature for specifics).</p><p> Nitrogen from a house supply requires a single-stage regulator if the supply is at a pressure higher than the specified range. Bottled, compressed nitrogen typically requires a dual-stage regulator. See <a href='https://www.agilent.com/' target='_blank'>www.agilent.com</a> for dual-stage regulators available from Agilent Technologies.</p></div><div class='textContainer textContainer_100'><p style='margin-top:0px;'>The 6400 Series LC/TQ is supplied with 300 centimeter of heavy-wall 1/4-inch PTFE tubing to connect the nitrogen supply to the 6400 Series LC/TQ . You may need to supply additional heavy-wall 1/4-inch PTFE tubing if the nitrogen supply is located farther from the 6400 Series LC/TQ system. You can substitute 1/4-inch medical-grade polypropylene tubing for the PTFE tubing. You must supply fittings, ferrules, and connectors of a Swagelok design for the 1/4-inch tubing.</p></div></div>" ,
												details:{									
												1:{
												text: "Nitrogen regulators, tubing, and fittings , You must supply appropriate regulators for your sources of nitrogen gas. The regulators must be able to supply gas in the specified pressure ranges. , The regulator for the drying gas must have one outlet with 1/4- inch Swagelok fittings. Gas generators have built-in regulators so they do not require an external regulator. A dewar of liquid nitrogen typically requires a regulator (see the dewar manufacturer's literature for specifics). , Nitrogen from a house supply requires a single-stage regulator if the supply is at a pressure higher than the specified range. Bottled, compressed nitrogen typically requires a dual-stage regulator. See www.agilent.com for dual-stage regulators available from Agilent Technologies. , The 6400 Series LC/TQ is supplied with 300 centimeter of heavy-wall 1/4-inch PTFE tubing to connect the nitrogen supply to the 6400 Series LC/TQ . You may need to supply additional heavy-wall 1/4-inch PTFE tubing if the nitrogen supply is located farther from the 6400 Series LC/TQ system. You can substitute 1/4-inch medical-grade polypropylene tubing for the PTFE tubing. You must supply fittings, ferrules, and connectors of a Swagelok design for the 1/4-inch tubing."
												},								 
												}
											}, // page
										]  //pageList
						},//subChapter
		
		    }//subChapterList			
		}, // chapter 
		
		7:{ 			
				chapterName : "Laboratory supply requirements",
				iconPath : "images/submenuicon/LCTQ/Laboratory_Supply_Requirements.png",
				subChapterList : {
					1:{ 
							subChapterName : "Laboratory supply requirements",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [  
											{  
											title: "Operating supplies" ,
											short_title: "Operating supplies" ,
											type: "tools" ,
											content:"<div id='dataContainer'><div class='textContainer textContainer_100'>Agilent recommends that the highest grade solvents available be used. Lower purity grades will result in higher background levels. Order your solvents from <a href='https://www.agilent.com/'>www.agilent.com</a>.</div></div>",
											details: {									
													1:{ imagePath: "images/topic01/tools/Acetonitrile.jpg",
														text : "Acetonitrile",
														Part_number : "p/n G2453-85050"
													  },
													2 :{ imagePath: "images/topic01/tools/Methonol.jpg",
														text : "Methanol",
														Part_number : "p/n 5190-6896"
													  },
													3 :{ imagePath: "images/topic01/tools/LC_MS_grade_water.jpg",
														text : "LC/MS Water (4 Liter)",
														Part_number : "p/n 5190-6897"
													  },
													4 :{ imagePath: "images/topic01/tools/Formic_acid.jpg",
														text : "Ammonium formate, 97% purity or better",
														Part_number : "p/n G1946-85021"
													  },
													5 :{ imagePath: "images/topic01/tools/Acetic_acid.jpg",
														text : "Acetic acid, 99.7% minimum purity",
														
													  },
													6 :{ imagePath: "images/topic01/tools/Formic_acid.jpg",
														text : "Formic acid, 95% minimum purity",
														Part_number : "p/n G2453-85060 "
													  },
													7 :{ imagePath: "images/topic01/tools/isopropyl_alcohol.png",
														text : "Isopropyl alcohol, minimum 99% purity. LC/MS grade",
														
													  },
											}
											}, // page
											
											 
											
											{  
												title: "Fume hood" ,
												short_title: "Fume hood" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>An auxiliary work space and fume hood are needed for some maintenance procedures.</div><div class='imageContainer_80'><img src='images/topic01/fume_hood.jpg'></div>",
												details:{									
												1:{
												text: "Fume hood , An auxiliary work space and fume hood are needed for some maintenance procedures."
												},								 
												}
											}, // page
										 
											
											 
											
 
										]  //pageList
						},//subChapter

							
		    }//subChapterList			
		}, // chapter 
		
		8:{ 			
				chapterName : "Delivery and installation",
				iconPath : "images/submenuicon/Delivery_and_Installation.png",
				iconPath : "images/submenuicon/Delivery_and_Installation.png",
				subChapterList : {
					1:{ 
							subChapterName : "Delivery and installation",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [
										{  
											title: "Delivery and unloading" ,
											short_title: "Delivery and unloading" ,
											type: "text_image" ,
											content : '<div id="dataContainer"><div style="margin-right:12px;width: 290px;float: left; margin-bottom: 15px;"><img src="images/topic01/Forklift.jpg"></div><div class="textContainer textContainer_70">The Agilent system shipping containers are large and very heavy. Refer to the Site Preparation Checklist for the dimensions and mass of the Agilent system base unit shipping container. Additional shipping containers contain the Agilent system ship kit and PC data system.<p>The shipping containers require a loading dock and a fork lift or simliar lifting device. <i>If no loading dock and/or suitable lifting device is available, the containers cannot be removed from the delivery truck</i>. If you make prior arrangements with your Agilent service representative, the system can be delivered in a lift-gate truck. This removes the need for a loading dock, but a lifting device is still required to move the containers.</p></div><div class="textContainer textContainer_100"><span class="caution">CAUTION</span>The shipping container must be kept upright at all times to prevent damage to the instrument. All doorways, hallways, floors, and elevators must be able to accommodate the container.<br><br> </div></div>' ,
											details: {										
												1:{
													text: "Delivery and unloading , The Agilent system shipping containers are large and very heavy. Refer to the Site Preparation Checklist for the dimensions and mass of the Agilent system base unit shipping container. Additional shipping containers contain the Agilent system ship kit and PC data system. , The shipping containers require a loading dock and a fork lift or simliar lifting device. , If no loading dock and/or suitable lifting device is available, the containers cannot be removed from the delivery truck. If you make prior arrangements with your Agilent service representative, the system can be delivered in a lift-gate truck. This removes the need for a loading dock, but a lifting device is still required to move the containers. , CAUTION , The shipping container must be kept upright at all times to prevent damage to the instrument. All doorways, hallways, floors, and elevators must be able to accommodate the container.  " 
													},								 
												
												
												}
										},
										
										{  
											title: "Inspection" ,
											short_title: "Inspection" ,
											type: "text_image" ,
											content :"<div id='dataContainer'><div class='textContainer textContainer_100'>Once the shipping containers are unloaded, examine them for any obvious external damage. If any of the containers appear damaged, note on the carrier's bill of lading that there is: <span style='color:#0086dd;'>Apparent damage - subject to inspection and test</span>. Arrange for both the carrier's claims representative and your Agilent service representative to be present when the containers are unpacked.<p>Do not open any of the shipping containers unless a representative of Agilent Technologies is present. Opening any of the containers without an Agilent Technologies representative being present will void the receiving warranty on the Instrument.</p></div></div>",
											details: {										
												1:{
													text: "Inspection , Once the shipping containers are unloaded, examine them for any obvious external damage. If any of the containers appear damaged, note on the carrier's bill of lading that there is: , Apparent damage - subject to inspection and test. Arrange for both the carrier's claims representative and your Agilent service representative to be present when the containers are unpacked. , Do not open any of the shipping containers unless a representative of Agilent Technologies is present. Opening any of the containers without an Agilent Technologies representative being present will void the receiving warranty on the Instrument." 
													},								 
												
												
												}
										},
										
										{  
											title: "Inspection" ,
											short_title: "blank" ,
											type: "video" ,
											path : "video/topic02/Inspection.mp4" ,
											PdfPath : "pdf/topic01/Inspection.pdf",
											details: 
													{
													
													1:{ cuePoint : 5,
													tag:"Examination of shipping containers",
													text: "Once the shipping containers are unloaded, examine them for any obvious external damage."
													},
													
													2:{ cuePoint :13,
													tag:"Apparent damage - subject to inspection and test",
													text: "If any of the containers appear damaged, note on the carrier's bill of lading that there is: Apparent damage - subject to inspection and test. "
													},
													
													3:{ cuePoint :21,
													tag:"Warranty condition",
													text: "Do not open any of the shipping containers unless a representative of Agilent Technologies is present. Opening any of the containers without an Agilent Technologies representative being present will void the receiving warranty on the Instrument."
													},
													
												}
										},
										
										{  
											title: "Storage" ,
											short_title: "Storage" ,
											type: "text_image" ,
											content: "<div id='dataContainer'><div class='textContainer textContainer_100'>It is your responsibility to store the containers until installation. If your site does not have adequate storage space, the containers will be stored at your expense in a bonded warehouse. Allow space for data system and accessory containers too.<p>The environment in the storage area should be between -20 °C and 50 °C (-4 °F and 122 °F), 20% to 80% relative humidity, non-condensing and non-corrosive.</p><p>There are chemicals that are shipped with the system that may also require refrigeration between 4 and 8 °C. Additionally, some of these chemicals should not be exposed to temperatures below 5 °C (41 °F).</p></div></div>" ,
											details: {										
												1:{
													text: "Storage , It is your responsibility to store the containers until installation. If your site does not have adequate storage space, the containers will be stored at your expense in a bonded warehouse. Allow space for data system and accessory containers too. , The environment in the storage area should be between -20 °C and 50 °C (-4 °F and 122 °F), 20% to 80% relative humidity, non-condensing and non-corrosive. , There are chemicals that are shipped with the system that may also require refrigeration between 4 and 8 °C. Additionally, some of these chemicals should not be exposed to temperatures below 5 °C (41 °F)." 
													},								 
												
												
												}
										},
										
										{  
											title: "Unpacking" ,
											short_title: "blank" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'>Supplies that require refrigeration are shipped separately from the instrument. Open and refrigerate immediately upon delivery.<p>Do not open any other shipping containers until an Agilent representative is present to verify the contents of each container as it is unpacked. The actual shipping containers become your property and should not be returned to Agilent Technologies.​</p><p>If the product is coming from a cold storage environment, allow time for thermal equilibration to room temperature before opening the shipping containers. This will avoid exposing the instrument to condensing humidity.</p></div></div>" ,
											details: {										
												1:{
													text: "Unpacking , Supplies that require refrigeration are shipped separately from the instrument. Open and refrigerate immediately upon delivery.​, Do not open any other shipping containers until an Agilent representative is present to verify the contents of each container as it is unpacked. The actual shipping containers become your property and should not be returned to Agilent Technologies.​, If the product is coming from a cold storage environment, allow time for thermal equilibration to room temperature before opening the shipping containers. This will avoid exposing the instrument to condensing humidity." 
													},								 
												
												
												}
										},
										
										{  
											title: "Unpacking" ,
											short_title: "Unpacking" ,
											type: "video" ,
											path : "video/topic03/Unpacking.mp4" ,
											PdfPath : "pdf/topic04/Unpacking.pdf",
											details: 
													{
													
													1:{ cuePoint : 01,
													tag:"Allow time for thermal equilibration to room temperature",
													text: "If the product is coming from a cold storage environment, allow time for thermal equilibration to room temperature before opening the shipping containers. This will avoid exposing the instrument to condensing humidity."
													},
													
													2:{ cuePoint :14,
													tag:"Warranty condition",
													text: "Do not open any shipping containers until an Agilent representative is present. Warranty claims for missing items will not be honored unless an Agilent representative is present to verify the contents of each container as it is unpacked."
													},
													
													3:{ cuePoint :29,
													tag:"blank",
													text: "The actual shipping containers become your property and should not be returned to Agilent Technologies."
													},
													
												}
										},
										
										{  
											title: "Installation" ,
											short_title: "Installation" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'>After installation begins, the installation will progress in a timely manner to completion. Delays due to inadequate site preparation could cause loss of instrument use during the warranty period. In extreme cases, Agilent Technologies may ask to be reimbursed for the additional time required to complete the installation.<p>The LC/TQ base unit is too heavy to be lifted by one person. At least four people must be available to lift the LC/TQ onto the laboratory bench.</p><p>The primary user of the LC/TQ should be present during installation to receive familiarization instruction from the Agilent service representative.</p></div></div>" ,
											details: {										
												1:{
													text: " Installation , After installation begins, the installation will progress in a timely manner to completion. Delays due to inadequate site preparation could cause loss of instrument use during the warranty period. In extreme cases, Agilent Technologies may ask to be reimbursed for the additional time required to complete the installation. , The LC/TQ base unit is too heavy to be lifted by one person. At least four people must be available to lift the LC/TQ onto the laboratory bench. , The primary user of the LC/TQ should be present during installation to receive familiarization instruction from the Agilent service representative. " 
													},								 
												
												
												}
										},
										
										{  
											title: "Verification" ,
											short_title: "Verification" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'><div style='display:inline-block;'><div style='float:left;text-align: center;padding: 10px;border:1px solid #b3b3b3;margin-right:15px;line-height:0;'><img src='images/topic01/check_list.jpg'></div><div>The final step in the installation process is system verification. Your Agilent service representative will test the system against Agilent standards as documented in the LC/TQ Installation Guide.</div></div><p>As part of verification, the Agilent service representative will not test your system against your standards or samples. Furthermore, the Agilent Engineer will not set up your laboratory procedures. Assistance with laboratory procedures can be obtained from Agilent on a consulting basis at an additional cost.</p></div></div>" ,
											details: {										
												1:{
													text: "Verification , The final step in the installation process is system verification. Your Agilent service representative will test the system against Agilent standards as documented in the LC/TQ Installation Guide. , As part of verification, the Agilent service representative will not test your system against your standards or samples. Furthermore, the Agilent Engineer will not set up your laboratory procedures. Assistance with laboratory procedures can be obtained from Agilent on a consulting basis at an additional cost. " 
													},								 
												
												
												}
										},
										
										{  
											title: "Recycling" ,
											short_title: "Recycling" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'><div style='float:left'><img src='images/topic01/recycle.jpg' style='width:50px;margin-right:10px;'></div><div>For recycling, contact your local Agilent sales representative office.</div></div></div>" ,
											details: {										
												1:{
													text: "Recycling , For recycling, contact your local Agilent sales representative office." 
													},								 
												
												
												}
										},
				
									]	
						},//subChapter

							
				}//subChapterList			
		}, // chapter 
 		9:{ 			
				chapterName : "Reference",
				iconPath : "images/submenuicon/Reference.png",
				subChapterList : {				
							1:{
								subChapterName : "Reference",
								iconPath : "images/submenuicon/no_image.png",
								submenu : true,
								pageList : [  
											{  
													title: "Power cords" ,
													short_title: "Power cords" ,
													type: "text_image" ,
													content:'<div id="dataContainer"><div class="textContainer textContainer_100">Following are the power cords (IEC C19) available for the 6400 Series LC/TQ. See the section Electrical Requirements for information about ensuring that the correct power cord is supplied with your system.<h4>US and Canada, NEMA 6-15P (Agilent p/n 8120-8623)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/pc1.jpg"></img></div><p>An alternative power cord (G1946-60066) with a NEMA L6-30P connector is available at extra cost. It is useful if a twist-lock plug is desired.</p><h4>European Power, CEE 7/7 (Agilent p/n 8120-8621)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic03/pc2.jpg"></img></div></div></div>',
													
													details:{									
														1:{
														text: "Power cords , Following are the power cords (IEC C19) available for the 6400 Series LC/TQ. See the section Electrical Requirements for information about ensuring that the correct power cord is supplied with your system. , US and Canada, NEMA 6-15P (Agilent p/n 8120-8623) , An alternative power cord (G1946-60066) with a NEMA L6-30P connector is available at extra cost. It is useful if a twist-lock plug is desired. , European Power, CEE 7/7 (Agilent p/n 8120-8621) , UK / Hong Kong / Malaysia / Singapore, BS 1363 (Agilent p/n 8120-8620)"
														}
													}, // pages
												},
												
												{  
												title: "Power cords" ,
												short_title: "blank" ,
												type: "text_image" ,
												content:'<div id="dataContainer"><div class="textContainer textContainer_100"><h4>UK / Hong Kong / Malaysia / Singapore, BS 1363 (Agilent p/n 8120-8620)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/pc3.jpg"></img></div><h4>Switzerland / Denmark, IEC 309 (Agilent p/n 8120-8622)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/pc4.jpg"></img></div><h4>Australia, (Agilent p/n 8120-8619)</h4><h4>China, (Agilent p/n 8121-0070)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/pc5.jpg"></img></div></div></div>',
												
												details:{									
													1:{
													text: "Power cords , Switzerland / Denmark, IEC 309 (Agilent p/n 8120-8622) , Australia, (Agilent p/n 8120-8619) , China, (Agilent p/n 8121-0070)"
													}
												}, // pages
												},
												
												{  
												title: "Power cords" ,
												short_title: "blank" ,
												type: "text_image" ,
												content:'<div id="dataContainer"><div class="textContainer textContainer_100"><h4>India / South Africa, BS 546 (Agilent p/n 8121-0710)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/India_South Africa.jpg"></img></div><h4>Israel, SI 32 (Agilent p/n 8121-0161)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/Israel.jpg"></img></div><h4>Japan NEMA L6-20P (Agilent p/n 8120-6903)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/japan.jpg"></img></div></div></div>',						
												details:{									
													1:{
													text: "Power cords , India / South Africa, BS 546 (Agilent p/n 8121-0710) , Israel, SI 32 (Agilent p/n 8121-0161) , Japan NEMA L6-20P (Agilent p/n 8120-6903)"
													}
												}, // pages
												},
												
												{  
												title: "Power cords" ,
												short_title: "blank" ,
												type: "text_image" ,
												content:'<div id="dataContainer"><div class="textContainer textContainer_100"><h4>Taiwan / South America, NEMA 6-20P (Agilent p/n 8120-6360)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic03/pc7.jpg"></img></div><h4>Korea, (Agilent p/n 8121-1222)</h4><h4>(Not Shown)</h4><h4>Thailand, (Agilent p/n 8121-1301)</h4><h4>(Not Shown)</h4></div></div>',
												
												details:{									
													1:{
													text: "Power cords , Taiwan / South America, NEMA 6-20P (Agilent p/n 8120-6360) , Korea, (Agilent p/n 8121-1222) , (Not Shown) , Thailand, (Agilent p/n 8121-1301) , (Not Shown)"
													}
												}, // pages
												},
											
											]  //pageList
								}, // subChapter 
						}// subChapterList		
		}, // chapter

	} // chapterList	
  },
}//topic
  
  

  
