﻿var topic1 = {  
topicInfo:{ 	
		topicId : 1,
		topicName : "InfinityLab LC/MSD Series MSD", 
		iconPath : "images/submenuicon/lc_msd_iq/lc_msd_iq.png",
		small_iconPath : "images/sprite/no_image.png",
		chapterList:{
			1:{ 			
				chapterName : "Important",
				iconPath : "images/submenuicon/important_icon.png",
				subChapterList:{
					1:{
						subChapterName : "Important",
						iconPath : "images/submenuicon/no_image.png",
						submenu : true,
						pageList : [	
									{  
									title: "Warranty" ,
									short_title: "Warranty",
									type: "text_image" ,
									content:'<div id="dataContainer"><div class="textContainer textContainer_100">The material contained in this document is provided “as is”, and is subject to being changed, without notice, in future editions. Further, to the maximum extent permitted by applicable law, Agilent disclaims all warranties, either express or implied, with regard to this manual and any information contained herein, including but not limited to the implied warranties of merchantability and fitness for a particular purpose.<p> Agilent shall not be liable for errors or for incidental or consequential damages in connection with the furnishing, use, or performance of this document or of any information contained herein. Should Agilent and the user have a separate written agreement with warranty terms covering the material in this document that conflict with these terms, the warranty terms in the separate agreement shall control.</p></div></div>',
									details: {									
											1:{
												text: "Warranty , The material contained in this document is provided “as is”, and is subject to being changed, without notice, in future editions. Further, to the maximum extent permitted by applicable law, Agilent disclaims all warranties, either express or implied, with regard to this manual and any information contained herein, including but not limited to the implied warranties of merchantability and fitness for a particular purpose. , Agilent shall not be liable for errors or for incidental or consequential damages in connection with the furnishing, use, or performance of this document or of any information contained herein. Should Agilent and the user have a separate written agreement with warranty terms covering the material in this document that conflict with these terms, the warranty terms in the separate agreement shall control."
											  },								 
											}
									},
										
									{  
									title: "Safety notices" ,
									short_title: "Safety notices" ,
									type: "text_image" ,
									content:'<div id="dataContainer"><div class="textContainer textContainer_100"><span class="caution">CAUTION</span> <br><br>A CAUTION notice denotes a hazard. It calls attention to an operating procedure, practice, or the like that, if not correctly performed or adhered to, could result in damage to the product or loss of important data. Do not proceed beyond a CAUTION notice until the indicated conditions are fully understood and met.<br><br><span class="warning">WARNING</span><br><br>A WARNING notice denotes a hazard. It calls attention to an operating procedure, practice, or the like that, if not correctly performed or adhered to, could result in personal injury or death. Do not proceed beyond a WARNING notice until the indicated conditions are fully understood and met.<p>For more information about safety and conformity, refer to the <a href="https://www.agilent.com/cs/library/usermanuals/public/G1960-90113_6000_Safety.pdf" target="#" style="color:rgb(0, 133, 213)">6000 Series LC/MS Safety Guide</a>.</p></div></div>',
									details: {									
											1:{
												text: "Safety notices , CAUTION , A CAUTION notice denotes a hazard. It calls attention to an operating procedure, practice, or the like that, if not correctly performed or adhered to, could result in damage to the product or loss of important data. Do not proceed beyond a CAUTION notice until the indicated conditions are fully understood and met. , WARNING , A WARNING notice denotes a hazard. It calls attention to an operating procedure, practice, or the like that, if not correctly performed or adhered to, could result in personal injury or death. Do not proceed beyond a WARNING notice until the indicated conditions are fully understood and met. , For more information about safety and conformity, refer to the 6000 Series LC/MS Safety Guide."
											  },								 
											}
									},
									{  
										title: "Overview" ,
										short_title: "Overview" ,
										type: "text_image" ,
										content : '<div id="dataContainer"><div class="textContainer textContainer_100">This section describes how to properly prepare your site for a new Agilent LC/MS instrument. Follow these instructions carefully as delays due to improper site preparation may result in loss of instrument use during the warranty period.<p>Before the Agilent LC/MS instrument system can be installed, the site must be properly prepared. Site preparation includes, but is not limited to, ensuring that adequate facilities are available. Among the site requirements are:<div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/power_51.jpg"></img></div><p style="float:left;">Adequate electrical power is available at the correct voltages and frequencies.</p><div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/Envorment.jpg"></img></div><p style="float:left;">Environmental control systems are adequate to maintain a correct, stable operating environment.</p><div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/Dry_nitrogen_gas.jpg"></img></div><p style="float:left;">An adequate source of clean, dry nitrogen gas.</p><div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/venting.jpg"></img></div><p style="float:left;">Adequate exhaust venting.</p><div class="imageContainer imageContainer_100" style="margin: 0px 10px 0px 0px;clear:both"><img src="images/topic01/Paper.jpg"></img></div><p style="float:left;margin:15px 10px 0px 0px;">Supplies necessary for instrument operation are available, including solvents, carrier and reagent gases, and printer paper.</p></div><div class="textContainer textContainer_100"> <p>Refer to the Site Preparation Checklist for specific requirements.​</p></div></div>' ,
										details: {										
											1:{
												text: "Overview , This section describes how to properly prepare your site for a new Agilent LC/MS instrument. Follow these instructions carefully as delays due to improper site preparation may result in loss of instrument use during the warranty period. , Before the InfinityLab LC/MSD Series MSD  system can be installed, the site must be properly prepared. Site preparation includes, but is not limited to, ensuring that adequate facilities are available. Among the site requirements are: , Adequate electrical power is available at the correct voltages and frequencies. , Environmental control systems are adequate to maintain a correct, stable operating environment. , An adequate source of clean, dry nitrogen gas. , Adequate exhaust venting. , Supplies necessary for instrument operation are available, including solvents, carrier and reagent gases, and printer paper.,Refer to the Site Preparation Checklist for specific requirements.​" 
												},								 
											
											}
										},
										{  
										title: "Overview" ,
										short_title: "blank",
										type: "text_image" ,
										content : '<div id="dataContainer"><div class="textContainer textContainer_100">Delays due to inadequate site preparation could cause loss of instrument use during the warranty period. In extreme cases, Agilent Technologies may ask to be reimbursed for the additional time required to complete the installation. <p><i>Agilent Technologies provides service during the warranty period and under maintenance agreements only if the specified site requirements are met.</i></p></div></div>' ,
										details: {										
											1:{
												text: "Overview , Delays due to inadequate site preparation could cause loss of instrument use during the warranty period. In extreme cases, Agilent Technologies may ask to be reimbursed for the additional time required to complete the installation. , Agilent Technologies provides service during the warranty period and under maintenance agreements only if the specified site requirements are met." 
												},								 
											
											}
										},
									
								  ]	
					},// subchapter	  
					
				} // subchapter List 			
			}, // chapter 
			2:{ 			
				chapterName : "General information",
				iconPath : "images/submenuicon/General_Information.png",
				subChapterList:{
					1:{
						subChapterName : "General information",
						iconPath : "images/submenuicon/General_Information.png",
						submenu : false,
						pageList : [	
									{  
									title: "Instrument identification" ,
									short_title: "Instrument identification" ,
									type: "text_image" ,
									content:'<div id="dataContainer"><div class="textContainer textContainer_100">Each Agilent LC/MS is identified by a unique 10-character serial number. This serial number is located on a label on the lower right front corner of the instrument. When corresponding with Agilent Technologies about your instrument, be sure to include the model number and the full 10-character serial number.</div><div class="imageContainer imageContainer_100"><img src="images/topic02/instrument_Serial_no.jpg"></img></div></div>',
									details: {									
											1:{
												text: "Each Agilent LC/MS is identified by a unique 10-character serial number. This serial number is located on a label on the lower right front corner of the instrument. When corresponding with Agilent Technologies about your instrument, be sure to include the model number and the full 10-character serial number."
											  },								 
											}
									},
									
								  ]	
						} // subchapter	  
					} // subchapter List 			
			}, // chapter 
 
			
			3:{ 			
				chapterName : "Lab space requirements",
				iconPath : "images/submenuicon/lc_msd_iq/Lab_Space_Requirements.png",
				subChapterList : {
					1:{ 
							subChapterName : "Lab space requirements",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [
								            {  
											title: "Bench requirement" ,
											short_title: "Bench requirement" ,
											type: "text_image" ,
											content : '<div id="dataContainer"><div class="textContainer textContainer_100">Supporting benches for the InfinityLab LC/MSD Series MSD system are available from Agilent. Contact your Agilent representatives for ordering information on the appropriate bench for your lab.<br><br><div class="imageContainer imageContainer_80" style="padding-top: 20px; float:none"><img src="images/topic02/bench_requirement.png"></img></div></div></div>' ,
											details:{									
											1:{
											text: "Bench requirement , Supporting benches for the InfinityLab LC/MSD Series MSD system are available from Agilent. Contact your Agilent representatives for ordering information on the appropriate bench for your lab."
											},								 
											}
											}, // page
											
											{  
											title: "Space and weight requirements" ,
											short_title: "Space and weight requirements" ,
											type: "text_image" ,
											content : '<div id="dataContainer"><div class="textContainer textContainer_100">The bench space must be large enough and strong enough to support the LC/MS and LC system, data system, and accessories. The surface must be relatively free of vibration.​<br><br> Please refer to the Site Preparation Checklist, under <b>Dimensions and Weight</b>, for the LC/MS, source, and foreline pump dimensions and weight.​ <br><br>You must leave at least 30 cm (12 inches) in front of the source and the rear fan to provide adequate access and ventilation.<br><br>The InfinityLab Flex Bench can also be used to support the InfinityLab LC/MSD Series MSD and LC system.</div></div>' ,/*<div class="tableBorder"></div> */
											details:{									
											1:{
											text: "The bench space must be large enough and strong enough to support the LC/MS and LC system, data system, and accessories. The surface must be relatively free of vibration.​, Please refer to the Site Preparation Checklist, under Dimensions and Weight, for the LC/MS, source, and foreline pump dimensions and weight.​, You must leave at least 30 cm (12 inches) in front of the source and the rear fan to provide adequate access and ventilation., The InfinityLab Flex Bench can also be used to support the InfinityLab LC/MSD Series MSD and LC system."
											},								 
											}
											}, // page
											
											{  
											title: "Space and weight requirements – LC/MSD iQ​" ,
											short_title: "blank",
											type: "video" ,
											path : "video/topic01/space_and_weight.mp4" ,
											PdfPath : "pdf/topic02/space_and_weight.pdf",
										
											details: {
											1:{ cuePoint : 0,
												tag:"Adequate space",
												text: "Adequate space is available for the LC/MSD iQ system."
											  },
										
											2:{ cuePoint :3,
												tag:"Suitable supporting bench",
												text: "A suitable supporting bench is available.<br>The supporting surface must be sturdy enough to support the weight of the entire LC/MSD iQ system and any accessories."
											  },
											  
											3:{ cuePoint :11,
												tag:"blank",
												text: " "
											  },
										  
											4:{ cuePoint : 12,
												tag:"Dimensions of LC/MSD iQ",
												text: "Total height of LC/MSD iQ is 33 cm (13 inches)."
											  },
										
											5:{ cuePoint : 14,
												tag:"blank",
												text: "Total height of LC/MSD iQ is 33 cm (13 inches). <br>Total width of LC/MSD iQ​ is 39.5 cm (15.6 inches)."
											  },
											  
											6:{ cuePoint :22,
												tag:"blank",
												text: " "
											  },
											  
											7:{ cuePoint : 24,
												tag:"blank",
												text: "Total depth of LC/MSD iQ is 54.6 cm (21.5 inches)."
											  },
											  
											8:{ cuePoint : 29,
												tag:"blank",
												text: " "
											  },
											  
											9:{ cuePoint : 31,
												tag:"blank",
												text: "There must be sufficient space around the instrumentation for air flow and maintenance access.<br> At least 30 cm (12 inches) space should be maintained behind the LC/MSD iQ system."
											  },
										
											 10:{ cuePoint : 37,
												tag:"blank",
												text: " "
											  },
											  
											11:{ cuePoint : 39,
												tag:"Dimensions of foreline pump and drain bottle",
												text: "The foreline pump(s) must be located under the laboratory bench or on the floor. <br> A 200 cm (79 inches) vacuum hose must be able to connect between the foreline pump and the back of the LC/MSD iQ ."
											  },
											  
											
											  
											12:{ cuePoint : 45,
												tag:"blank",
												text: "Waste bottle must be positioned below the LC/MSD iQ instrument. The drain bottle is supplied with a 180 cm (72 inches) PTFE hose."
											  },
											  
											13:{ cuePoint : 49,
												tag:"blank",
												text: " "
											  },
											}
											}, // page
										 
											
											{  
											title: "Space and weight requirements – LC/MSD and LC/MSD XT​" ,
											short_title: "blank",
											type: "video" ,
											path : "video/topic01/space_and_weight_LCMSD_XT.mp4" ,
											PdfPath : "pdf/topic02/space_and_weight.pdf",
										
											details: {
											 1:{ cuePoint : 0,
												tag:"Adequate space",
												text: "Adequate space is available for the LC/MSD and LC/MSD XT system."
											  },
										
											 2:{ cuePoint :3,
												tag:"Suitable supporting bench",
												text: "A suitable supporting bench is available.<br>The supporting surface must be sturdy enough to support the weight of the entire LC/MSD and LC/MSD XT system and any accessories."
											  },
											  
											 3:{ cuePoint :13,
												tag:"blank",
												text: " "
											  },
										  
											 4:{ cuePoint : 15,
												tag:"Dimensions of LC/MSD <br> and LC/MSD XT",
												text: "Total height of LC/MSD and LC/MSD XT is 47 cm (18.5 inches)."
											  },
										
											 5:{ cuePoint : 20,
												tag:"blank",
												text: "Total height of LC/MSD and LC/MSD XT is 47 cm (18.5 inches). <br>Total width of LC/MSD and LC/MSD XT​ is 44.25 cm (17.4 inches)."
											  },
										 
											 6:{ cuePoint : 27,
												tag:"blank",
												text: " "
											  }, 
											 7:{ cuePoint : 28,
												tag:"blank",
												text: "Total depth of LC/MSD and LC/MSD XT is 63.5 cm (25 inches)."
											  },

											 8:{ cuePoint : 35,
												tag:"blank",
												text: " "
											  },

											 9:{ cuePoint : 36,
												tag:"Drain hose requirement",
												text: "Your bench must allow a drain hose to drop directly down from the source."
											  }, 
											10:{ cuePoint : 41,
												tag:"blank",
												text: "If you cannot or do not want to allow the ion source to protrude over the table edge, <br> drill a hole 3.2 cm (1.25 inches) wide for the drain hose."
											  }, 
											
											11:{ cuePoint : 56,
												tag:"blank",
												text: "At least 30 cm (12 inches) space to right and left of the instrument should be maintained for proper ventilation. And no other devices (e.g. a nitrogen generator) should exhaust into this side of the instrument."
											  }, 
											12:{ cuePoint : 63,
												tag:"blank",
												text: " "
											  }, 
											13:{ cuePoint : 65,
												tag:"blank",
												text: "Waste bottle must be positioned below the Ultivo LC/TQ instrument. The drain bottle is supplied with a 180 cm (72 inches) PTFE hose."
											  }, 
											14:{ cuePoint : 71,
												tag:"Exhaust hose requirement",
												text: "Your bench must allow the vacuum hose to drop behind the chassis to the pump under the bench."
											  }, 
											15:{ cuePoint : 76,
												tag:"blank",
												text: "If your bench is fixed against a wall, drill a hole 5 cm (2 inches) wide for the vacuum hose."
											  }, 
											16:{ cuePoint : 87,
												tag:"blank", 
												text: " "
											  }, 

											17:{ cuePoint : 88,
												tag:"blank",
												text: "The foreline pump(s) must be located under the laboratory bench or on the floor. <br> A 200 cm (79 inches) vacuum hose must be able to connect between the foreline pump and the back of the LC/MSD and LC/MSD XT."
											  },
											  
											18:{ cuePoint : 91,
												tag:"blank",
												text: " "
											 	 },
											}
											}, // page
											
											{  
											title: "Space and weight requirements" ,
											short_title: "blank" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'><div class='imageContainer imageContainer_100'><img src='images/topic02/suggested_config.jpg'></img></div></div></div>" ,
											details:{									
											1:{
											text: "Space and weight requirements"
											},								 
											}
											}, // page
											
								 
											{  
											title: "Operating environment" ,
											short_title: "Operating environment" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'><h4>Environmental Conditions</h4>The LC/MSD is designed for use in the following environmental conditions for Class 1 Laboratory equipment, as specified by the International Electro-technical Commission (IEC).<table style='margin-top:10px;'><tr><td>Equipment class</td><td>Class 1 Laboratory equipment</td></tr><tr><td>Pollution</td><td>Degree 2</td></tr><tr><td>Installation</td><td>Category II</td></tr><tr><td>Environment</td><td>Indoor use</td></tr><tr><td>Altitude</td><td>Not to exceed 3,000 m (10,000 ft)</td></tr><tr><td>Electrical supply</td><td>See the Site Preparation Checklist for specific information for your model.</td></tr> <tr><td rowspan='2' style='padding-bottom:45px'>Mains supply voltage</td><td>For ESI: Fluctuations not to exceed 10% of nominal supply voltage.</td></tr><tr><td>For AJS: Fluctuations not to exceed +10/-5% from the rated voltage.</td></tr><tr><td>Operating temperature</td><td>15 to 35 °C (59 to 95 °F)</td></tr><tr><td>Humidity</td><td>< 85% RH at 35 °C</td></tr></table>" ,
											details:{									
											1:{
											text: "Operating environment , Environmental Conditions , The InfinityLab LC/MSD iQ is designed for use in the following environmental conditions for Class 1 Laboratory equipment, as specified by the International Electro-technical Commission (IEC). , Equipment class , Class 1 Laboratory equipment , Pollution , Degree 2 , Installation , Category II , Environment , Indoor use , Altitude , Not to exceed 3,000 m (10,000 ft) , Electrical supply , See the Site Preparation Checklist for specific information for your model, Fluctuations not to exceed 10% of nominal supply voltage , Operating temperature , 15 to 35 °C (59 to 95 °F) , Humidity , < 85% RH at 35 °C,Mains supply voltage, For ESI: Fluctuations not to exceed 10% of nominal supply voltage., For AJS: Fluctuations not to exceed +10/-5% from the rated voltage."
											},								 
											}
											}, // page
											
											{  
											title: "Operating environment" ,
											short_title: "blank" ,
											type: "video" ,
											path : "video/topic01/Operating_Environment.mp4" ,
											PdfPath : "pdf/topic02/Operating_Environment.pdf",
											details: 
													{
														
													1:{ cuePoint : 2,
													tag:"Altitude",
													text: "Altitude: Not to exceed 3,000 m (10,000 ft.)",
													},
													
													2:{ cuePoint : 5,
													tag:"InfinityLab LC/MSD Series MSD electrical supply",
													text: "Electrical supply: Refer to the Site Preparation Checklist for exact specifications.<br>Mains supply voltage fluctuation: ​<br>For ESI, not to exceed 10% of nominal supply voltage.​ <br>For AJS, not to exceed +10/-5% from the rated voltage."
													},
													
													3:{ cuePoint : 10,
													tag:"MS40+ pump electrical supply",
													text: "MS40+ pump electrical supply: 120 VAC (with optional transformer), or 220 VAC."
													},
													
													4:{ cuePoint :16,
													tag:"Operating temperature",
													text: "Operating Temperature: 15 to 35 &#176;C (59 to 95 &#176;F) "
													},
													
													5:{ cuePoint :20,
													tag:"Humidity",
													text: "Humidity: < 85% RH at 35 &#176;C"
													},
													
												}
											},
											
											{  
												title: "Telephone" ,
												short_title: "Telephone" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div style='float:left;margin-right:10px;'><img src='images/topic01/Telephone.jpg'></div><div class='textContainer textContainer_80'>Make sure a telephone or cell phone service is available within reach of the computer. The Agilent Technologies field personnel may need to communicate with an Agilent support personnel.</div></div>" ,
												details:{									
												1:{
												text: "Telephone , Make sure a telephone or cell phone service is available within reach of the computer. The Agilent Technologies field personnel may need to communicate with an Agilent support personnel."
												},								 
												}
											}, // page
											
											{  
												title: "LAN network" ,
												short_title: "LAN network" ,
												type: "text_image" ,
												content : "<div class='imageContainer imageContainer_100' style='float:left'><img src='images/topic02/LAN.jpg'></img></div>" ,
												details:{									
												1:{
												text: "LAN network"
												},								 
												}
											}, // page
											
											{  
												title: "Site LAN network" ,
												short_title: "blank" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'>If you intend to connect the control PC to your site's LAN network, you need an additional network cable. Internet access for the control PC is strongly recommended to allow remote control and diagnosis of the LC/MS through remote access software. This is required for some service contracts.<br><br><span class='note'>NOTE</span>Agilent Technologies is not responsible for connecting to or establishing communication with your site LAN network. The service representative will test the ability of the Agilent instruments to communicate with the control PC only.​<br><br><span class='note'>NOTE</span>The LC/MSD and LC/MSD XT have fixed IP addresses. They can only connect to a control PC and not to the site network. The LC/MSD iQ can connect to the site network. Consult your Agilent representative if you need to connect the LC/MSD iQ to a network environment.</div></div>" ,
												details:{									
												1:{
												text: "Site LAN network ,If you intend to connect the control PC to your site's LAN network, you need an additional network cable. Internet access for the control PC is strongly recommended to allow remote control and diagnosis of the LC/MS through remote access software. This is required for some service contracts., Agilent Technologies is not responsible for connecting to or establishing communication with your site LAN network. The service representative will test the ability of the Agilent instruments to communicate with the control PC only.​, The LC/MSD and LC/MSD XT have fixed IP addresses. They can only connect to a control PC and not to the site network. The LC/MSD iQ can connect to the site network. Consult your Agilent representative if you need to connect the LC/MSD iQ to a network environment."
												},								 
												}
											}, // page
											
								
							
										]  //pageList
						},//subChapter		
				}//subChapterList			
		}, // chapter 
		
		4:{ 			
				chapterName : "Air conditioning requirements",
				iconPath : "images/submenuicon/lc_msd_iq/Air_Conditioning_Requirements.png",
				subChapterList : {
					1:{ 
							subChapterName : "Air conditioning requirements",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [
											{  
											title: "Temperature and humidity" ,
											short_title: "Temperature and humidity" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'>The InfinityLab LC/MSD Series MSD is specified for operation under the following conditions:<ul><li>15 to 35 °C (59 to 95 °F)</li><li>Constant temperature (< +/-3 °C from calibration temperature)</li><li>< 85% relative humidity at 35 °C</li><li>Non-condensing, non-corrosive atmosphere</li></ul><p>Environmental control systems must maintain these temperatures and humidity ranges.</p><p>The LC/MS, source, and rough pump dissipate a large amount of heat. For your system specifications, refer to the Site Preparation Checklist.​<br>The LC and data system also contribute significantly to the cooling load. The exact amounts depend on their configurations.</p><p>Additional allowances should be made for other heat sources such as heat from other equipment, heat from adjacent rooms, and heat from laboratory personnel.</p></div></div>" ,
											details:{									
											1:{
											text: "Temperature and humidity , The InfinityLab LC/MSD Series MSD is specified for operation under the following conditions: , 15 to 35 °C (59 to 95 °F) , Constant temperature (< +/-3 °C from calibration temperature) , < 85% relative humidity at 35 °C , Non-condensing, non-corrosive atmosphere , Environmental control systems must maintain these temperatures and humidity ranges., The LC/MS, source, and rough pump dissipate a large amount of heat. For your system specifications, refer to the Site Preparation Checklist.​ , The LC and data system also contribute significantly to the cooling load. The exact amounts depend on their configurations.,Additional allowances should be made for other heat sources such as heat from other equipment, heat from adjacent rooms, and heat from laboratory personnel."
											},								 
											}
											}, // page
											
											{  
											title: "Temperature and humidity" ,
											short_title: "blank" ,
											type: "video" ,
											path : "video/topic01/temperature_n_humidity.mp4" ,
											PdfPath : "pdf/topic02/temperature_n_humidity.pdf",
										
											details: {
											1:{ cuePoint : 0,
												tag:"The InfinityLab LC/MSD Series MSD dissipates heat from the chassis and source",
												text: "The InfinityLab LC/MSD Series MSD dissipates heat from the chassis and source. Check the Site Preparation Checklist for rate of dissipation. "
											  },
										
											2:{ cuePoint : 14,
												tag:"The foreline pump dissipates heat",
												text: "The foreline pump dissipates heat. "
											  },
											  
											3:{ cuePoint : 20,
												tag:"The LC and data system also contribute significantly",
												text: "The LC and data system also contribute significantly. The exact amounts depend on their configurations."
											  },
											}
											}, // page
								 
											{  
											title: "Airborne dust" ,
											short_title: "Airborne dust" ,
											type: "video" ,
											path : "video/topic01/Airborne_Dust.mp4" ,
											PdfPath : "pdf/topic02/Airborne_Dust.pdf",
										
											details: {
											1:{ cuePoint : 0,
												tag:"Lab with airborne dust",
												text: "Agilent recommends a maximum airborne particle density of 55 mg/m<sup>3</sup>. If you suspect your site exceeds this limit, contact your local Agilent Customer Service Organization. They can offer suggestions for reducing airborne dust."
											  },
										
											2:{ cuePoint : 9,
												tag:"blank",
												text: " "
											  },
											  
											  
											}
											}, // page
											
											{  
											title: "Exhaust venting" ,
											short_title: "Exhaust venting" ,
											type: "video" ,
											path : "video/topic01/Exhaust_Venting.mp4" ,
											PdfPath : "pdf/topic02/Exhaust_Venting.pdf",
										
											details: {
											1:{ cuePoint : 0,
												tag:"Exhaust sources of the InfinityLab LC/MSD Series MSD",
												text: "Two sources of exhaust on the InfinityLab LC/MSD Series MSD: the Spray Chamber via the Drain Bottle and the Foreline Pump."
											  },
											  
											2:{ cuePoint : 8,
												tag:"blank",
												text: " ",
											  },
										
											3:{ cuePoint : 9,
												tag:"blank",
												text: "There are two sources of exhaust vent on the agilent LC/TQ the spray chamber and foreline pump. The drain hose routes both nitrogen gas and vapor from the spray chamber to drain bottle. The vapor is made up of mobile phase and sample. The spray chamber and foreline pump vent up to 30 liters/minute of nitrogen gas and vapor. "
											  },
											  
											4:{ cuePoint : 16,
												tag:"blank",
												text: "Do not use a same hose for venting because the foreline pump exhaust contains traces of solvent, sample, and hydrocarbon pump fluid. The mist filter on the foreline pump traps the majority of the pump fluid vapor. It does not trap the traces of solvent and sample that may be present in the exhaust gases."
											  },
											  
											5:{ cuePoint : 27,
												tag:"blank",
												text: "Air needs to flow away from the instrument."
											  },
											  
											  
											6:{ cuePoint : 40,
												tag:"The spray chamber exhaust and the foreline pump exhaust are vented externally",
												text: "The spray chamber exhaust and the foreline pump exhaust are vented externally to the building and not recirculated by the environmental control system."
											  },
											
											7:{ cuePoint : 54,
												tag:"blank",
												text: " "
											  },
											}
											}, // page
											
											{  
											title: "Exhaust venting" ,
											short_title: "blank" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'><span class='warning'>WARNING</span>Failure to vent the rough pump and spray chamber separately will void the warranty for the LC/MS. Agilent service representatives will not install an InfinityLab LC/MSD Series MSD until an adequate exhaust system is present and functioning. <br><br><span class='caution'>CAUTION</span>The spray chamber exhaust and foreline pump exhaust must be vented using separate lengths of exhaust tubing. This is to minimize the chances of foreline pump fluid vapor entering the spray chamber when drying gas is not flowing.<p><span class='caution'>CAUTION</span>Your exhaust venting system must be able to handle the combined exhaust flow from the spray chamber and the rough pump. Refer the Site Preparation Checklist for the specifications for your system.</p><p><span class='caution'>CAUTION</span>Flow is continuous as long as the instrument is on. Both exhaust vents must be at or slightly below atmospheric pressure<br>(negative pressure). If a negative pressure vent is not available, the length of the tubing from the rough pump and the drain bottle to the vent should each not exceed 460 cm (180 inches).</p><p><span class='caution'>CAUTION</span>Positive pressure in the spray chamber exhaust tubing and drain bottle can affect instrument performance and may contribute to excessive background contaminant levels.<p></div></div>" ,
											details:{									
											1:{
											text: "Exhaust venting , CAUTION , The spray chamber exhaust and foreline pump exhaust must be vented using separate lengths of exhaust tubing. This is to minimize the chances of foreline pump fluid vapor entering the spray chamber when drying gas is not flowing. , Your exhaust venting system must be able to handle the combined exhaust flow from the spray chamber and the rough pump. Refer the Site Preparation Checklist for the specifications for your system., Positive pressure in the spray chamber exhaust tubing and drain bottle can affect instrument performance and may contribute to excessive background contaminant levels."
											},								 
											}
											}, // page
										]  //pageList
						},//subChapter

							
				}//subChapterList			
		}, // chapter 
		
		5:{ 			
				chapterName : "Electrical requirements",
				iconPath : "images/submenuicon/lc_msd_iq/Electrical_Requirements.png",
				subChapterList : {
					1:{ 
							subChapterName : "Electrical requirements",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [  
											{  
												title: "Voltage and power requirements" ,
												short_title: "Voltage and power requirements" ,
												type: "text_image" ,
												content : "<div id='dataContainer'><div class='textContainer textContainer_100'>The customer is responsible for providing appropriate electrical power and power outlets for all components and accessories used with the LC/MS system. Power considerations include: <ul><li>Voltage ranges of major components</li><li>Power requirements of major component	</li><li>Single-phase power configurations</li><li>Power plugs, receptacles and cords</li></ul><p>The LC/MS system includes a wide-range power supply that can operate without reconfiguration.</p><p><span class='note'>NOTE</span> The LC/MS, LC, and data system each requires a separate branch circuit breaker.</p><p>Refer to the Site Preparation Checklist for details on exact voltage and power requirements for your instrument and pump. </P><div style='display: inline-block;'><div style='float:left;text-align: center;padding: 20px;border:1px solid #b3b3b3;margin-right:15px;'><img src='images/topic01/power_51.jpg'></div><div style='margin-bottom:20px;'><span class='caution'>CAUTION</span>If an instrument is being ordered from one location, but is to be installed in another location with different electrical power characteristics, a special note must be made on the order that the electrical power at the site is different from the standard electrical power in that country.</div></div><p>Power must meet the stated stability specifications. Use a line monitor to check the power stability. If the line power is unstable, it may be necessary to install a line conditioner.</p></div></div>",
												details:{									
												1:{
												text: "Voltage and power requirements , The customer is responsible for providing appropriate electrical power and power outlets for all components and accessories used with the LC/MS system., Power considerations include: ,Voltage ranges of major components, Power requirements of major component	, Single-phase power configurations, Power plugs, receptacles and cords, The LC/MS system includes a wide-range power supply that can operate without reconfiguration., Note that the LC/MS, LC, and data system each requires a separate branch circuit breaker., Refer to the Site Preparation Checklist for details on exact voltage and power requirements for your instrument and pump. CAUTION , If an instrument is being ordered from one location, but is to be installed in another location with different electrical power characteristics, a special note must be made on the order that the electrical power at the site is different from the standard electrical power in that country. , Power must meet the stated stability specifications. Use a line monitor to check the power stability. If the line power is unstable, it may be necessary to install a line conditioner."
												},								 
												}
											}, // page
											 
											
											{  
											title: "Voltage and power requirements" ,
											short_title: "blank" ,
											type: "video" ,
											path : "video/topic01/voltage_range_n_power_requirement.mp4" ,
											PdfPath : "pdf/topic02/voltage_range_n_power_requirement.pdf",
										
											details: {
												1:{ cuePoint : 0,
													tag:"Relocate the radio or antenna",
													text: "Relocate the radio or antenna.<br>Move the device away from the radio or television."
												  },
											
												2:{ cuePoint : 9,
													tag:"Plug the device into a different electrical outlet",
													text: "Plug the device into a different electrical outlet, so that each device is on separate electrical circuits."
												  },
												  
												3:{ cuePoint : 28,
													tag:"blank",
													text: " "
												  }, 
												
												}
											}, // page
											
											{  
												title: "Power configurations" ,
												short_title: "Power configurations" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>Electrical power for the Agilent LC/MS may be delivered in either single-phase or 208 Wye configuration.<p>Refer to the Site Preparation Checklist for the primary voltage characteristics of each configuration. Correct grounding for the 208-Wye configuration must be verified by an electrician. The neutral wire cannot be used for safety grounding.</p><div style='display:inline-block;margin-bottom: 20px;'><div style='float:left;text-align: center;padding: 20px;border:1px solid #b3b3b3;margin-right:15px;'><img src='images/topic01/power_config.png'></div><div style='margin-bottom:20px;'>The ground wire should carry zero current except for ground-fault current or static electric discharge. The entire system should share an isolated, noise-free electrical ground that is connected to the main earth ground for the facility.</div></div><br><span class='warning'>WARNING</span>The power source to which you connect an Agilent LC/MS must be equipped with a protective earth contact (ground).<br><br><span class='warning'>WARNING</span>Do not interrupt the protective earth contact inside or outside the LC/MS or disconnect the protective earth terminal (ground).</div></div>" ,
												details:{									
												1:{
												text: "Power configurations , Electrical power for the Agilent LC/MS may be delivered in either single-phase or 208 Wye configuration. , Refer to the Site Preparation Checklist for the primary voltage characteristics of each configuration. Correct grounding for the 208-Wye configuration must be verified by an electrician. The neutral wire cannot be used for safety grounding. , The ground wire should carry zero current except for ground-fault current or static electric discharge. The entire system should share an isolated, noise-free electrical ground that is connected to the main earth ground for the facility. , WARNING , The power source to which you connect an Agilent LC/MS must be equipped with a protective earth contact (ground). , Do not interrupt the protective earth contact inside or outside the LC/MS or disconnect the protective earth terminal (ground)."
												},								 
												}
											}, // page
											
											 
											
											{  
												title: "Power plugs and cords" ,
												short_title: "Power plugs and cords" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>The LC/MS is supplied with an appropriate power cord and plug for the country in which the order originates. The length of all  power cords is approximately 2.4 m (94 inches).<p>The data system components also include power cords with plugs appropriate for the country in which the order was placed. Power cord lengths for the data system components and accessories are approximately 2.3 m (90 inches).</p><p>“Power cords” in the Reference section shows the style of the plug for the cord that will ship to your country. Make sure that the power receptacles in your laboratory can accommodate this configuration. If needed, consult with your Agilent representative.</p><span class='caution'>CAUTION</span>If an instrument is being ordered from one location, but is to be installed in another location with different <br>electrical power characteristics, a special note must be made on the order that the electrical power at the site is different from the standard electrical power in that country.<br> <br><div style='width:100%'><div style='width:90%;float:left'><span class='warning'>WARNING</span>Do not use extension cords with the LC/MS. Extension cords cannot provide enough power and can be a safety hazard.</div><div style='float:left;text-align: center;padding: 15px;border:1px solid #b3b3b3'><img src='images/topic01/extension_cord.jpg'></div></div></div></div>" ,
												details:{									
												1:{
												text: "Power plugs and cords , The LC/MS is supplied with an appropriate power cord and plug for the country in which the order originates. The length of all power cords is approximately 2.4 m (94 inches). , The data system components also include power cords with plugs appropriate for the country in which the order was placed. Power cord lengths for the data system components and accessories are approximately 2.3 m (90 inches). , CAUTION , If an instrument is being ordered from one location, but is to be installed in another location with different electrical power characteristics, a special note must be made on the order that the electrical power at the site is different from the standard electrical power in that country. ,  WARNING , Do not use extension cords with the LC/MS. Extension cords cannot provide enough power and can be a safety hazard."
												},								 
												}
											}, // page
											
											{  
												title: "Other electrical considerations" ,
												short_title: "Other electrical considerations" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>Additional electrical considerations include:<ul><li>Electromagnetic interference (EMI), such as is generated by NMRs, radio transmitters, and microwave links,<br> may interfere with system performance.</li><li>Protect the system from static electricity by observing humidity and temperature requirements. Minimize the presence of non-conductive products such as carpets and vinyl floor tiles.</li><li>Install emergency-off pushbuttons that can disconnect power to all electric equipment in the room except overhead lighting and <br>ventilation system.</li><li>Separate convenience outlets should be provided for building maintenance and other appliances. Convenience outlets must be on circuits separate from the InfinityLab LC/MSD Series MSD system. Convenience outlets must share the normal building distribution ground, not the InfinityLab LC/MSD Series MSD system ground.</li><li>In some geographical areas it may be advisable to install lightning protection for personnel and equipment.</li></ul></div></div>" ,
												details:{									
												1:{
												text: "Other electrical considerations , Additional electrical considerations include: , Electromagnetic interference (EMI), such as is generated by NMRs, radio transmitters, and microwave links, may interfere with system performance. , Protect the system from static electricity by observing humidity and temperature requirements. Minimize the presence of non-conductive products such as carpets and vinyl floor tiles. , Install emergency-off pushbuttons that can disconnect power to all electric equipment in the room except overhead lighting and ventilation system. , Separate convenience outlets should be provided for building maintenance and other appliances. Convenience outlets must be on circuits separate from the InfinityLab LC/MSD Series MSD system. Convenience outlets must share the normal building distribution ground, not the InfinityLab LC/MSD Series MSD system ground. , In some geographical areas it may be advisable to install lightning protection for personnel and equipment."
												},								 
												}
											}, // page
										]  //pageList
					},//subChapter
					
			},//subChapterList
		},//Chapter
			
		6:{ 			
				chapterName : "Gas requirements",
				iconPath : "images/submenuicon/lc_msd_iq/Gas_requirements.png",
				subChapterList : {
					1:{ 
							subChapterName : "Gas requirements",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [  
											{  
												title: "Nitrogen gas requirements" ,
												short_title: "Nitrogen gas requirements" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>The Agilent LC/MS requires a very large quantity of high-purity nitrogen for drying gas, sheath gas (for AJS source), nebulizing gas, and to pressurize the calibrant delivery system.<br><br><span class='warning'>WARNING</span>Use only nitrogen for the drying, sheath, nebulizing gas and collision cell gas. Use of air, oxygen, or other gases when combined with volatile solvents and high voltages in the spray chamber, could result in an explosion. Use of air, oxygen, or other gases may also cause deterioration of parts in the InfinityLab LC/MSD Series MSD and have a negative effect on instrument operation and sensitivity.<p>Due to the large volumes of nitrogen required for instrument operation, the use of a nitrogen generator (gas separator) or a large (160 liters or greater) dewar of liquid nitrogen is recommended. Agilent Technologies offers several nitrogen gas generators well suited for use with the LC/MS system. Check with your Agilent representative to purchase one of these generators. </p><span class='warning'>WARNING</span>Contact your gas supplier for handling and safety information for the gases you use. Compressed or liquefied gases can be dangerous.</div></div>" ,
												details:{									
												1:{ 
												text: "Nitrogen gas requirements , The Agilent LC/MS requires a very large quantity of high-purity nitrogen for drying gas, sheath gas (for AJS source), nebulizing gas, and to pressurize the calibrant delivery system. , WARNING , Use only nitrogen for the drying, sheath, nebulizing gas and collision cell gas. Use of air, oxygen, or other gases when combined with volatile solvents and high voltages in the spray chamber, could result in an explosion. Use of air, oxygen, or other gases may also cause deterioration of parts in the InfinityLab LC/MSD Series MSD and have a negative effect on instrument operation and sensitivity. , Due to the large volumes of nitrogen required for instrument operation, the use of a nitrogen generator (gas separator) or a large (160 liters or greater) dewar of liquid nitrogen is recommended. Agilent Technologies offers several nitrogen gas generators well suited for use with the LC/MS system. Check with your Agilent representative to purchase one of these generators. , WARNING , Contact your gas supplier for handling and safety information for the gases you use. Compressed or liquefied gases can be dangerous."
												},								 
												}
											}, // page
											
										 
											{  
												title: "Nitrogen purity" ,
												short_title: "Nitrogen purity" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>The nitrogen gas used for drying gas must be free of contaminants.  Nitrogen generators and nitrogen dewars are commonly used as the primary nitrogen source because they are the best to mitigate common contaminants that interfere with LC/MS. Nitrogen generators offer the advantages of less frequent maintenance and source gas filtration but are limited in their purity. Dewars generally offer a higher purity but do not inherently filter the source gas. Dewars also have a finite volume, which results in more frequent maintenance. <div style='width:102px;text-align:center;float:left;margin-right:10px;margin-bottom:10px;border:1px solid #b3b3b3;'><img src='images/topic02/Nitrogen_purity.jpg'></div><p style='padding-top:20px;'>One or more high-capacity gas conditioner is supplied with the Agilent LC/MS. Its primary function is to remove hydrocarbon contamination from the nitrogen before it reaches the LC/MS. Refer to the Site Preparation Checklist for nitrogen flow requirements for your system. This conditioner has 1/4-inch Swagelok fittings.</p> <br><br><span class='note'>NOTE</span>Use of high-pressure nitrogen bottles is not supported due the high usage rate.​<br><br><table><tr><th class='txt_center'>Source</th><th class='txt_center' width='400px'>Purity</th><th class='txt_center'>Gas Pressure</th> </tr>  <tr valign='top'> <td>Liquid nitrogen dewar or Nitrogen generator</td><td>>95.0% and hydrocarbon-free (less than 1 ppm, with the remaining gas being oxygen and trace argon)</td><td>5.5 to 6.8 bar<br>(80 to 100 PSI)<br>(550 to 690 kPa)​</td> </tr>     </table></div></div>" ,
												details:{									
												1:{
												text: "Nitrogen purity,The nitrogen gas used for drying gas must be free of contaminants. Purity specifications vary according to the source of the nitrogen. This is due to the different types of contaminants common to different nitrogen sources.,Oxygen is the primary contaminant of gas supplied by a nitrogen generator. Oxygen has less impact on LC/MS sensitivity, and in some operating modes and certain applications may enhance sensitivity in small concentrations. Therefore, the purity specification for gas from a nitrogen generator can be less stringent., One or more high-capacity gas conditioner is supplied with the Agilent LC/MS. Its primary function is to remove hydrocarbon contamination from the nitrogen before it reaches the LC/MS system. Refer to the Site Preparation Checklist for nitrogen flow requirements for your system. This conditioner has 1/4-inch Swagelok fittings.,Source	Purity	Gas Pressure,Liquid nitrogen dewar,	99.5% pure1 or better and hydrocarbon-free,	5.5 to 6.8 bar,(80 to 100 PSI),(550 to 690 kPa)​,Nitrogen generator	95.0% pure or better and,hydrocarbon-free2, 1 Bottled nitrogen tends to be contaminated with hydrocarbons, which can severely degrade LC/MS sensitivity. Even with the gas conditioner (purifier) supplied with the LCMS, all hydrocarbon contaminants cannot be removed unless the bottle nitrogen is at least 99.5% pure., 2 Less than 0.1 parts per million hydrocarbons with the remaining gas being oxygen and trace argon."
												},								 
												}
											}, // page

											{  
												title: "Nitrogen regulators, tubing, and fittings" ,
												short_title: "Nitrogen regulators, tubing, and fittings" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div style='float:left;margin:0 15px 0 15px'><img src='images/topic01/Regulator.jpg'></div><div class='textContainer' style='width:72%'>You must supply appropriate regulators for your sources of nitrogen gas. The regulators must be able to supply gas in the specified pressure ranges.<p>The regulator for the drying gas must have one outlet with 1/4- inch Swagelok fittings. Gas generators have built-in regulators so they do not require an external regulator. A dewar of liquid nitrogen typically requires a single-stage regulator (see the dewar manufacturer's literature for specifics).</p><p> Nitrogen from a house supply requires a single-stage regulator if the supply is at a pressure higher than the specified range. Bottled, compressed nitrogen typically requires a dual-stage regulator. See <a href='https://www.agilent.com/' target='_blank'>www.agilent.com</a> for dual-stage regulators available from Agilent Technologies.</p></div><div class='textContainer textContainer_100'><p style='margin-top:0px;'>The InfinityLab LC/MSD Series MSD is supplied with 300 centimeter of heavy-wall 1/4-inch PTFE tubing to connect the nitrogen supply to the InfinityLab LC/MSD Series MSD . You may need to supply additional heavy-wall 1/4-inch PTFE tubing if the nitrogen supply is located farther from the InfinityLab LC/MSD Series MSD system. You can substitute 1/4-inch medical-grade polypropylene tubing for the PTFE tubing. You must supply fittings, ferrules, and connectors of a Swagelok design for the 1/4-inch tubing.</p></div></div>" ,
												details:{									
												1:{
												text: "Nitrogen regulators, tubing, and fittings , You must supply appropriate regulators for your sources of nitrogen gas. The regulators must be able to supply gas in the specified pressure ranges. , The regulator for the drying gas must have one outlet with 1/4- inch Swagelok fittings. Gas generators have built-in regulators so they do not require an external regulator. A dewar of liquid nitrogen typically requires a single-stage regulator (see the dewar manufacturer's literature for specifics). , Nitrogen from a house supply requires a single-stage regulator if the supply is at a pressure higher than the specified range. Bottled, compressed nitrogen typically requires a dual-stage regulator. See www.agilent.com for dual-stage regulators available from Agilent Technologies. , The InfinityLab LC/MSD Series MSD is supplied with 300 centimeter of heavy-wall 1/4-inch PTFE tubing to connect the nitrogen supply to the InfinityLab LC/MSD Series MSD . You may need to supply additional heavy-wall 1/4-inch PTFE tubing if the nitrogen supply is located farther from the InfinityLab LC/MSD Series MSD system. You can substitute 1/4-inch medical-grade polypropylene tubing for the PTFE tubing. You must supply fittings, ferrules, and connectors of a Swagelok design for the 1/4-inch tubing."
												},								 
												}
											}, // page
										]  //pageList
						},//subChapter
		
		    }//subChapterList			
		}, // chapter 
		
		7:{ 			
				chapterName : "Laboratory supply requirements",
				iconPath : "images/submenuicon/lc_msd_iq/Laboratory_Supply_Requirements.png",
				subChapterList : {
					1:{ 
							subChapterName : "Laboratory supply requirements",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [  
											{  
											title: "Operating supplies" ,
											short_title: "Operating supplies" ,
											type: "tools" ,
											content:"<div id='dataContainer'><div class='textContainer textContainer_100'>Agilent recommends that the highest grade solvents available be used. Lower purity grades will result in higher background levels. Order your solvents from <a href='https://www.agilent.com/'>www.agilent.com</a>.</div></div>",
											details: {									
													1:{ imagePath: "images/topic01/tools/Acetonitrile.jpg",
														text : "Acetonitrile",
														Part_number : "p/n G2453-85050"
													  },
													2 :{ imagePath: "images/topic01/tools/Methonol.jpg",
														text : "Methanol",
														Part_number : "p/n 5190-6896"
													  },
													3 :{ imagePath: "images/topic01/tools/LC_MS_grade_water.jpg",
														text : "LC/MS Water (4 Liter)",
														Part_number : "p/n 5190-6897"
													  },
													4 :{ imagePath: "images/topic01/tools/Ammonium_formate.jpg",
														text : "Ammonium formate, 97% purity or better",
														Part_number : "p/n G1946-85021"
													  },
													5 :{ imagePath: "images/topic01/tools/Acetic_acid.jpg",
														text : "Acetic acid, 99.7% minimum purity",
														
													  },
													6 :{ imagePath: "images/topic01/tools/Formic_acid.jpg",
														text : "Formic acid, 95% minimum purity",
														Part_number : "p/n G2453-85060 "
													  },
													7 :{ imagePath: "images/topic01/tools/isopropyl_alcohol.png",
														text : "Isopropyl alcohol, minimum 99% purity. LC/MS grade",
														
													  },
											}
											}, // page
										 
											
											{  
												title: "Fume hood" ,
												short_title: "Fume hood" ,
												type: "text_image" ,
												content: "<div id='dataContainer'><div class='textContainer textContainer_100'>An auxiliary work space and fume hood are needed for some maintenance procedures.</div><div class='imageContainer_80'><img src='images/topic01/fume_hood.jpg'></div>",
												details:{									
												1:{
												text: "Fume hood , An auxiliary work space and fume hood are needed for some maintenance procedures."
												},								 
												}
											}, // page
										  
										]  //pageList
						},//subChapter

							
		    }//subChapterList			
		}, // chapter 
		
		8:{ 			
				chapterName : "Delivery and installation",
				iconPath : "images/submenuicon/Delivery_and_Installation.png",
				iconPath : "images/submenuicon/Delivery_and_Installation.png",
				subChapterList : {
					1:{ 
							subChapterName : "Delivery and installation",
							iconPath : "images/submenuicon/no_image.png",
							submenu : true,
							pageList : [
										{  
											title: "Delivery and unloading" ,
											short_title: "Delivery and unloading" ,
											type: "text_image" ,
											content : '<div id="dataContainer"><div style="margin-right:12px;width: 290px;float: left; margin-bottom: 15px;"><img src="images/topic01/Forklift.jpg"></div><div class="textContainer textContainer_70">The Agilent system shipping containers are large and very heavy. Refer to the Site Preparation Checklist for the dimensions and mass of the Agilent system base unit shipping container. Additional shipping containers contain the Agilent system ship kit and PC data system.<p>The shipping containers require a loading dock and a fork lift or simliar lifting device. <i>If no loading dock and/or suitable lifting device is available, the containers cannot be removed from the delivery truck</i>. If you make prior arrangements with your Agilent service representative, the system can be delivered in a lift-gate truck. This removes the need for a loading dock, but a lifting device is still required to move the containers.</p></div><div class="textContainer textContainer_100"><span class="caution">CAUTION</span>The shipping container must be kept upright at all times to prevent damage to the instrument. All doorways, hallways, floors, and elevators must be able to accommodate the container.<br><br> </div></div>' ,
											details: {										
												1:{
													text: "Delivery and unloading , The Agilent system shipping containers are large and very heavy. Refer to the Site Preparation Checklist for the dimensions and mass of the Agilent system base unit shipping container. Additional shipping containers contain the Agilent system ship kit and PC data system. , The shipping containers require a loading dock and a fork lift or simliar lifting device. , If no loading dock and/or suitable lifting device is available, the containers cannot be removed from the delivery truck. , If you make prior arrangements with your Agilent service representative, the system can be delivered in a lift-gate truck. This removes the need for a loading dock, but a lifting device is still required to move the containers. , CAUTION , The shipping container must be kept upright at all times to prevent damage to the instrument. All doorways, hallways, floors, and elevators must be able to accommodate the container. " 
													},								 
												
												
												}
										},
										
										{  
											title: "Inspection" ,
											short_title: "Inspection" ,
											type: "text_image" ,
											content :"<div id='dataContainer'><div class='textContainer textContainer_100'>Once the shipping containers are unloaded, examine them for any obvious external damage. If any of the containers appear damaged, note on the carrier's bill of lading that there is: <span style='color:#0086dd;'>Apparent damage - subject to inspection and test</span>. Arrange for both the carrier's claims representative and your Agilent service representative to be present when the containers are unpacked.<p>Do not open any of the shipping containers unless a representative of Agilent Technologies is present. Opening any of the containers without an Agilent Technologies representative being present will void the receiving warranty on the Instrument.</p></div></div>",
											details: {										
												1:{
													text: "Inspection , Once the shipping containers are unloaded, examine them for any obvious external damage. If any of the containers appear damaged, note on the carrier's bill of lading that there is: , Apparent damage - subject to inspection and test. Arrange for both the carrier's claims representative and your Agilent service representative to be present when the containers are unpacked. , Do not open any of the shipping containers unless a representative of Agilent Technologies is present. Opening any of the containers without an Agilent Technologies representative being present will void the receiving warranty on the Instrument." 
													},								 
												
												
												}
										},
										
										{  
											title: "Inspection" ,
											short_title: "blank" ,
											type: "video" ,
											path : "video/topic02/Inspection.mp4" ,
											PdfPath : "pdf/topic02/Inspection.pdf",
											details: 
													{
													
													1:{ cuePoint : 5,
													tag:"Examination of shipping containers",
													text: "Once the shipping containers are unloaded, examine them for any obvious external damage."
													},
													
													2:{ cuePoint :13,
													tag:"Apparent damage - subject to inspection and test",
													text: "If any of the containers appear damaged, note on the carrier's bill of lading that there is: Apparent damage - subject to inspection and test. "
													},
													
													3:{ cuePoint :21,
													tag:"Warranty condition",
													text: "Do not open any of the shipping containers unless a representative of Agilent Technologies is present. Opening any of the containers without an Agilent Technologies representative being present will void the receiving warranty on the Instrument."
													},
													
												}
										},
										
										{  
											title: "Storage" ,
											short_title: "Storage" ,
											type: "text_image" ,
											content: "<div id='dataContainer'><div class='textContainer textContainer_100'>It is your responsibility to store the containers until installation. If your site does not have adequate storage space, the containers will be stored at your expense in a bonded warehouse. Allow space for data system and accessory containers too.<p>The environment in the storage area should be between -20 °C and 50 °C (-4 °F and 122 °F), 20% to 80% relative humidity, <br>non-condensing and non-corrosive.</p><p>There are chemicals that are shipped with the system that may also require refrigeration between 4 and 8 °C. Additionally, some of these chemicals should not be exposed to temperatures below 5 °C (41 °F).</p></div></div>" ,
											details: {										
												1:{
													text: "Storage , It is your responsibility to store the containers until installation. If your site does not have adequate storage space, the containers will be stored at your expense in a bonded warehouse. Allow space for data system and accessory containers too. , The environment in the storage area should be between -20 °C and 50 °C (-4 °F and 122 °F), 20% to 80% relative humidity, non-condensing and non-corrosive. , There are chemicals that are shipped with the system that may also require refrigeration between 4 and 8 °C. Additionally, some of these chemicals should not be exposed to temperatures below 5 °C (41 °F)." 
													},								 
												
												
												}
										},
										
										{  
											title: "Unpacking" ,
											short_title: "blank" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'>Supplies that require refrigeration are shipped separately from the instrument. Open and refrigerate immediately upon delivery.<p>Do not open any other shipping containers until an Agilent representative is present to verify the contents of each container as it is unpacked. The actual shipping containers become your property and should not be returned to Agilent Technologies.</p><p>If the product is coming from a cold storage environment, allow time for thermal equilibration to room temperature before opening the shipping containers. This will avoid exposing the instrument to condensing humidity.</p></div></div>" ,
											details: {										
												1:{
													text: "Unpacking , Supplies that require refrigeration are shipped separately from the instrument. Open and refrigerate immediately upon delivery.​,Do not open any other shipping containers until an Agilent representative is present to verify the contents of each container as it is unpacked. The actual shipping containers become your property and should not be returned to Agilent Technologies.​,If the product is coming from a cold storage environment, allow time for thermal equilibration to room temperature before opening the shipping containers. This will avoid exposing the instrument to condensing humidity." 
													},								 
												
												
												}
										},
										
										{  
											title: "Unpacking" ,
											short_title: "Unpacking" ,
											type: "video" ,
											path : "video/topic01/Unpacking.mp4" ,
											PdfPath : "pdf/topic02/Unpacking.pdf",
											details: 
													{
													
													1:{ cuePoint : 5,
													tag:"Allow time for thermal equilibration to room temperature",
													text: "If the product is coming from a cold storage environment, allow time for thermal equilibration to room temperature before opening the shipping containers. This will avoid exposing the instrument to condensing humidity."
													},
													
													2:{ cuePoint :14,
													tag:"Warranty condition",
													text: "Do not open any shipping containers until an Agilent representative is present. Warranty claims for missing items will not be honored unless an Agilent representative is present to verify the contents of each container as it is unpacked."
													},
													
													3:{ cuePoint :29,
													tag:"blank",
													text: "The actual shipping containers become your property and should not be returned to Agilent Technologies."
													},
													
												}
										},
										
										{  
											title: "Installation" ,
											short_title: "Installation" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'>After installation begins, the installation will progress in a timely manner to completion. Delays due to inadequate site preparation could cause loss of instrument use during the warranty period. In extreme cases, Agilent Technologies may ask to be reimbursed for the additional time required to complete the installation.<p>The InfinityLab LC/MSD Series MSD base unit is too heavy to be lifted by one person. Two people must be available to lift the InfinityLab LC/MSD Series MSD onto the laboratory bench.</p><p>The primary user of the InfinityLab LC/MSD Series MSD should be present during installation to receive familiarization instruction from the Agilent service representative.</p></div></div>" ,
											details: {										
												1:{
													text: "Installation , After installation begins, the installation will progress in a timely manner to completion. Delays due to inadequate site preparation could cause loss of instrument use during the warranty period. In extreme cases, Agilent Technologies may ask to be reimbursed for the additional time required to complete the installation. , The InfinityLab LC/MSD Series MSD base unit is too heavy (approximately 47 kg/104 lbs) to be lifted by one person. At least three people must be available to lift the InfinityLab LC/MSD Series MSD onto the laboratory bench. , The primary user of the InfinityLab LC/MSD Series MSD should be present during installation to receive familiarization instruction from the Agilent service representative." 
													},								 
												
												
												}
										},
										
										{  
											title: "Verification" ,
											short_title: "Verification" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'><div style='display:inline-block;'><div style='float:left;text-align: center;padding: 10px;border:1px solid #b3b3b3;margin-right:15px;line-height:0;'><img src='images/topic01/check_list.jpg'></div><div>The final step in the installation process is system verification. Your Agilent service representative will test the system against Agilent standards as documented in the InfinityLab LC/MSD Series MSD System Installation Guide.</div></div><p>As part of verification, the Agilent service representative will not test your system against your standards or samples. Furthermore, the Agilent Engineer will not set up your laboratory procedures. Assistance with laboratory procedures can be obtained from Agilent on a consulting basis at an additional cost.</p></div></div>" ,
											details: {										
												1:{
													text: "Verification , The final step in the installation process is system verification. Your Agilent service representative will test the system against Agilent standards as documented in the InfinityLab LC/MSD Series MSD System Installation Guide. , As part of verification, the Agilent service representative will not test your system against your standards or samples. Furthermore, the Agilent Engineer will not set up your laboratory procedures. Assistance with laboratory procedures can be obtained from Agilent on a consulting basis at an additional cost." 
													},								 
												
												
												}
										},
										
										{  
											title: "Recycling" ,
											short_title: "Recycling" ,
											type: "text_image" ,
											content : "<div id='dataContainer'><div class='textContainer textContainer_100'><div style='float:left'><img src='images/topic01/recycle.jpg' style='width:50px;margin-right:10px;'></div><div>For recycling, contact your local Agilent sales representative office.</div></div></div>" ,
											details: {										
												1:{
													text: "Recycling , For recycling, contact your local Agilent sales representative office." 
													},								 
												
												
												}
										},
				
									]	
						},//subChapter

							
				}//subChapterList			
		}, // chapter 
		9:{ 			
				chapterName : "Reference",
				iconPath : "images/submenuicon/Reference.png",
				subChapterList : {				
							1:{
								subChapterName : "Reference",
								iconPath : "images/submenuicon/no_image.png",
								submenu : true,
								pageList : [  
											 
									 {  
													title: "Power cords" ,
													short_title: "Power cords" ,
													type: "text_image" ,
													content:'<div id="dataContainer"><div class="textContainer textContainer_100">Following are the power cords (IEC C19) available for the InfinityLab LC/MSD Series MSD. See the section Electrical Requirements for information about ensuring that the correct power cord is supplied with your system.<h4>US and Canada, NEMA 6-15P (Agilent Part Number 8120-8623)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/pc1.jpg"></img></div><h4> US and Canada, NEMA 5-15P (Agilent p/n 8120-8623) - for LC/MSD iQ only</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/Power_Cord.jpg"></img></div> <h4>European Power, CEE 7/7 (Agilent p/n 8120-8621)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic03/pc2.jpg"></img></div></div></div>',
													
													details:{									
														1:{
														text: "Power cords , Following are the power cords (IEC C19) available for the InfinityLab LC/MSD Series MSD. See the section Electrical Requirements for information about ensuring that the correct power cord is supplied with your system. , US and Canada, NEMA 5-15P (Agilent p/n 8120-8623) for LC/MSD iQ only, , European Power, CEE 7/7 (Agilent p/n 8120-8621) , UK / Hong Kong / Malaysia / Singapore, BS 1363 (Agilent p/n 8120-8620)"
														}
													}, // pages
												},
												
												{  
												title: "Power cords" ,
												short_title: "blank" ,
												type: "text_image" ,
												content:'<div id="dataContainer"><div class="textContainer textContainer_100"><h4>UK / Hong Kong / Malaysia / Singapore, BS 1363 (Agilent p/n 8120-8620)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/pc3.jpg"></img></div><h4>Switzerland / Denmark, IEC 309 (Agilent p/n 8120-8622)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/pc4.jpg"></img></div><h4>Australia, (Agilent p/n 8120-8619)</h4><h4>China, (Agilent p/n 8121-0070)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/pc5.jpg"></img></div></div></div>',
												
												details:{									
													1:{
													text: "Power cords , Switzerland / Denmark, IEC 309 (Agilent p/n 8120-8622) , Australia, (Agilent p/n 8120-8619) , China, (Agilent p/n 8121-0070)"
													}
												}, // pages
												},
												
												{  
												title: "Power cords" ,
												short_title: "blank" ,
												type: "text_image" ,
												content:'<div id="dataContainer"><div class="textContainer textContainer_100"><h4>India / South Africa, BS 546 (Agilent p/n 8121-0710)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/India_South Africa.jpg"></img></div><h4>Israel, SI 32 (Agilent p/n 8121-0161)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/Israel.jpg"></img></div><h4>Japan NEMA L6-20P (Agilent p/n 8120-6903)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic01/japan.jpg"></img></div></div></div>',						
												details:{									
													1:{
													text: "Power cords , India / South Africa, BS 546 (Agilent p/n 8121-0710) , Israel, SI 32 (Agilent p/n 8121-0161) , Japan NEMA L6-20P (Agilent p/n 8120-6903)"
													}
												}, // pages
												},
												
												{  
												title: "Power cords" ,
												short_title: "blank" ,
												type: "text_image" ,
												content:'<div id="dataContainer"><div class="textContainer textContainer_100"><h4>Taiwan / South America, NEMA 6-20P (Agilent p/n 8120-6360)</h4><div class="imageContainer imageContainer_100" style="float:none"><img src="images/topic03/pc7.jpg"></img></div><h4>Korea, (Agilent p/n 8121-1222)</h4><h4>(Not Shown)</h4><h4>Thailand, (Agilent p/n 8121-1301)</h4><h4>(Not Shown)</h4></div></div>',
												
												details:{									
													1:{
													text: "Power cords , Taiwan / South America, NEMA 6-20P (Agilent p/n 8120-6360) , Korea, (Agilent p/n 8121-1222) , (Not Shown) , Thailand, (Agilent p/n 8121-1301) , (Not Shown)"
													}
												}, // pages
												},

										]  //pageList
								}, // subChapter 
						}// subChapterList		
		}, // chapter

	 

	} // chapterList	
  },
}//topic
  
  

  
